/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.IdempotenceAwareRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LoggingIdempotenceAwareRetryPolicy
extends IdempotenceAwareRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LoggingIdempotenceAwareRetryPolicy.class);
    private final AtomicBoolean warned = new AtomicBoolean();

    public LoggingIdempotenceAwareRetryPolicy(RetryPolicy childPolicy) {
        super(childPolicy);
    }

    @Override
    public void init(Cluster cluster) {
        super.init(cluster);
        this.warn("Initializing cluster with idempotence-aware retry policy");
    }

    @Override
    protected boolean isIdempotent(Statement statement) {
        boolean isIdempotent = super.isIdempotent(statement);
        if (this.warned.compareAndSet(false, true) && !isIdempotent) {
            this.warn("Not retrying statement because it is not idempotent (this message will be logged only once)");
        }
        return isIdempotent;
    }

    private void warn(String message) {
        logger.warn("{}. Note that this version of the driver changes the default retry behavior for non-idempotent statements: they won't be automatically retried anymore. The driver marks statements non-idempotent by default, so you should explicitly call setIdempotent(true) if your statements are safe to retry. See http://goo.gl/4HrSby for more details.", (Object)message);
    }
}

