/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WkbSerializationProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] wkb;

    WkbSerializationProxy(ByteBuffer wkb) {
        this.wkb = Bytes.getArray(wkb);
    }

    private Object readResolve() {
        ByteBuffer buffer = ByteBuffer.wrap(this.wkb).order(ByteOrder.nativeOrder());
        int type = buffer.getInt(1);
        if (type == 1) {
            return Point.fromWellKnownBinary(buffer);
        }
        if (type == 2) {
            return LineString.fromWellKnownBinary(buffer);
        }
        if (type == 3) {
            return Polygon.fromWellKnownBinary(buffer);
        }
        throw new IllegalArgumentException("Unknown geospatial type code in serialized form: " + type);
    }
}

