/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.DefaultVertex;
import com.datastax.driver.dse.graph.PropertyGraphNode;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonToken;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;

class DefaultVertexDeserializer
extends StdDeserializer<DefaultVertex> {
    DefaultVertexDeserializer() {
        super(DefaultVertex.class);
    }

    @Override
    public DefaultVertex deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
        DefaultVertex vertex = new DefaultVertex();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            assert (parser.getCurrentToken() == JsonToken.FIELD_NAME);
            String name = parser.getCurrentName();
            parser.nextToken();
            if ("id".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                vertex = this.readId(vertex, parser);
                continue;
            }
            if ("label".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                vertex = this.readLabel(vertex, parser);
                continue;
            }
            if ("type".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                vertex = this.readType(vertex, parser);
                continue;
            }
            if ("properties".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    assert (parser.getCurrentToken() == JsonToken.FIELD_NAME);
                    String key = parser.getCurrentName();
                    parser.nextToken();
                    vertex = this.readProperty(vertex, key, parser);
                }
                continue;
            }
            parser.nextToken();
            parser.skipChildren();
        }
        return vertex;
    }

    private DefaultVertex readId(DefaultVertex vertex, JsonParser parser) throws IOException {
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        vertex.id = new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec());
        return vertex;
    }

    private DefaultVertex readLabel(DefaultVertex vertex, JsonParser parser) throws IOException {
        vertex.label = parser.readValueAs(String.class);
        return vertex;
    }

    private DefaultVertex readType(DefaultVertex vertex, JsonParser parser) throws IOException {
        String type = parser.readValueAs(String.class);
        if (type == null || !type.equals("vertex")) {
            throw new JsonParseException(parser, String.format("Expected 'vertex' type, got '%s'", type));
        }
        return vertex;
    }

    private DefaultVertex readProperty(DefaultVertex vertex, String propertyName, JsonParser parser) throws IOException {
        if (vertex.properties == null) {
            vertex.properties = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        }
        assert (parser.getCurrentToken() == JsonToken.START_ARRAY);
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
            JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
            PropertyGraphNode propertyValue = new PropertyGraphNode(jacksonNode, (ObjectMapper)parser.getCodec(), propertyName, vertex);
            vertex.properties.put((Object)propertyName, (Object)propertyValue);
        }
        return vertex;
    }
}

