/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.TypeInfo;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.shaded.jackson.annotation.JsonTypeInfo;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.databind.BeanProperty;
import com.datastax.shaded.jackson.databind.jsontype.TypeIdResolver;
import com.datastax.shaded.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class GraphSONTypeSerializer
extends TypeSerializer {
    private final TypeIdResolver idRes;
    private final String propertyName;
    private final TypeInfo typeInfo;
    private final String valuePropertyName;

    GraphSONTypeSerializer(TypeIdResolver idRes, String propertyName, TypeInfo typeInfo, String valuePropertyName) {
        this.idRes = idRes;
        this.propertyName = propertyName;
        this.typeInfo = typeInfo;
        this.valuePropertyName = valuePropertyName;
    }

    @Override
    public TypeSerializer forProperty(BeanProperty beanProperty) {
        return this;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return null;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this.idRes;
    }

    @Override
    public void writeTypePrefixForScalar(Object o, JsonGenerator jsonGenerator) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypePrefix(jsonGenerator, this.getTypeIdResolver().idFromValueAndType(o, this.getClassFromObject(o)));
        }
    }

    @Override
    public void writeTypePrefixForObject(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
    }

    @Override
    public void writeTypePrefixForArray(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
    }

    @Override
    public void writeTypeSuffixForScalar(Object o, JsonGenerator jsonGenerator) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypeSuffix(jsonGenerator);
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    @Override
    public void writeTypeSuffixForArray(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndArray();
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypePrefix(jsonGenerator, s);
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
    }

    @Override
    public void writeCustomTypePrefixForArray(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartArray();
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypeSuffix(jsonGenerator);
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeEndObject();
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeEndArray();
    }

    private boolean canWriteTypeId() {
        return this.typeInfo != null && this.typeInfo == TypeInfo.PARTIAL_TYPES;
    }

    private void writeTypePrefix(JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(this.getPropertyName(), s);
        jsonGenerator.writeFieldName(this.valuePropertyName);
    }

    private void writeTypeSuffix(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    private Class getClassFromObject(Object o) {
        Class<?> c = o.getClass();
        if (Vertex.class.isAssignableFrom(c)) {
            return Vertex.class;
        }
        if (Edge.class.isAssignableFrom(c)) {
            return Edge.class;
        }
        if (VertexProperty.class.isAssignableFrom(c)) {
            return VertexProperty.class;
        }
        if (Property.class.isAssignableFrom(c)) {
            return Property.class;
        }
        if (Path.class.isAssignableFrom(c)) {
            return Path.class;
        }
        if (InetAddress.class.isAssignableFrom(c)) {
            return InetAddress.class;
        }
        if (ByteBuffer.class.isAssignableFrom(c)) {
            return ByteBuffer.class;
        }
        return c;
    }
}

