/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.AttributeStreamBase;
import com.datastax.shaded.esri.Envelope2D;
import com.datastax.shaded.esri.GeometryException;
import com.datastax.shaded.esri.NumberUtils;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.Point2D;
import com.datastax.shaded.esri.VertexDescription;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class AttributeStreamOfDbl
extends AttributeStreamBase {
    double[] m_buffer = null;
    int m_size;

    public int size() {
        return this.m_size;
    }

    public void reserve(int reserve) {
        if (reserve <= 0) {
            return;
        }
        if (this.m_buffer == null) {
            this.m_buffer = new double[reserve];
        } else {
            if (reserve <= this.m_buffer.length) {
                return;
            }
            double[] buf = new double[reserve];
            System.arraycopy(this.m_buffer, 0, buf, 0, this.m_size);
            this.m_buffer = buf;
        }
    }

    public AttributeStreamOfDbl(int size) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        this.m_size = size;
    }

    public AttributeStreamOfDbl(int size, double defaultValue) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        this.m_size = size;
        Arrays.fill(this.m_buffer, 0, size, defaultValue);
    }

    public AttributeStreamOfDbl(AttributeStreamOfDbl other) {
        this.m_buffer = (double[])other.m_buffer.clone();
        this.m_size = other.m_size;
    }

    public AttributeStreamOfDbl(AttributeStreamOfDbl other, int maxSize) {
        int sz;
        this.m_size = other.size();
        if (this.m_size > maxSize) {
            this.m_size = maxSize;
        }
        if ((sz = this.m_size) < 2) {
            sz = 2;
        }
        this.m_buffer = new double[sz];
        System.arraycopy(other.m_buffer, 0, this.m_buffer, 0, this.m_size);
    }

    public double read(int offset) {
        return this.m_buffer[offset];
    }

    public double get(int offset) {
        return this.m_buffer[offset];
    }

    public void write(int offset, double value) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value;
    }

    public void set(int offset, double value) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value;
    }

    public void read(int offset, Point2D outPoint) {
        outPoint.x = this.m_buffer[offset];
        outPoint.y = this.m_buffer[offset + 1];
    }

    void write(int offset, Point2D point) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = point.x;
        this.m_buffer[offset + 1] = point.y;
    }

    public void add(double v) {
        this.resize(this.m_size + 1);
        this.m_buffer[this.m_size - 1] = v;
    }

    @Override
    public AttributeStreamBase restrictedClone(int maxsize) {
        AttributeStreamOfDbl clone = new AttributeStreamOfDbl(this, maxsize);
        return clone;
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public int getPersistence() {
        return 1;
    }

    @Override
    public double readAsDbl(int offset) {
        return this.read(offset);
    }

    @Override
    public int readAsInt(int offset) {
        return (int)this.read(offset);
    }

    @Override
    public long readAsInt64(int offset) {
        return (long)this.read(offset);
    }

    @Override
    public void resize(int newSize) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                double[] newBuffer = new double[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                double[] newBuffer = new double[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void resizePreserveCapacity(int newSize) {
        if (this.m_buffer == null || newSize > this.m_buffer.length) {
            this.resize(newSize);
        }
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        this.m_size = newSize;
    }

    @Override
    public void resize(int newSize, double defaultValue) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                double[] newBuffer = new double[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                double[] newBuffer = new double[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            Arrays.fill(this.m_buffer, this.m_size, newSize, defaultValue);
            this.m_size = newSize;
        }
    }

    @Override
    public void writeAsDbl(int offset, double d) {
        this.write(offset, d);
    }

    @Override
    public void writeAsInt64(int offset, long d) {
        this.write(offset, d);
    }

    @Override
    public void writeAsInt(int offset, int d) {
        this.write(offset, d);
    }

    public void setEnvelopeFromPoints(int pointCount, Envelope2D inOutEnv) {
        if (pointCount == 0) {
            inOutEnv.setEmpty();
            return;
        }
        if (pointCount < 0) {
            pointCount = this.size() / 2;
        } else if (pointCount * 2 > this.size()) {
            throw new IllegalArgumentException();
        }
        inOutEnv.setCoords(this.read(0), this.read(1));
        for (int i = 1; i < pointCount; ++i) {
            inOutEnv.mergeNE(this.read(i * 2), this.read(i * 2 + 1));
        }
    }

    @Override
    public int calculateHashImpl(int hashCodeIn, int start, int end) {
        int hashCode = hashCodeIn;
        int n = this.size();
        for (int i = start; i < n && i < end; ++i) {
            hashCode = NumberUtils.hash(hashCode, this.read(i));
        }
        return hashCode;
    }

    @Override
    public boolean equals(AttributeStreamBase other, int start, int end) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeStreamOfDbl)) {
            return false;
        }
        AttributeStreamOfDbl _other = (AttributeStreamOfDbl)other;
        int size = this.size();
        int sizeOther = _other.size();
        if (end > size || end > sizeOther && size != sizeOther) {
            return false;
        }
        if (end > size) {
            end = size;
        }
        for (int i = start; i < end; ++i) {
            if (this.read(i) == _other.read(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addRange(AttributeStreamBase src, int start, int count, boolean bForward, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.m_size;
        int newSize = oldSize + count;
        this.resize(newSize);
        if (bForward) {
            System.arraycopy(((AttributeStreamOfDbl)src).m_buffer, start, this.m_buffer, oldSize, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[oldSize + i + s] = ((AttributeStreamOfDbl)src).m_buffer[start + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, AttributeStreamBase src, int srcStart, int count, boolean bForward, int stride, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int excess_space = this.m_size - validSize;
        if (excess_space < count) {
            int original_size = this.m_size;
            this.resize(original_size + count - excess_space);
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        if (this.m_buffer == ((AttributeStreamOfDbl)src).m_buffer && start < srcStart) {
            srcStart += count;
        }
        if (bForward) {
            System.arraycopy(((AttributeStreamOfDbl)src).m_buffer, srcStart, this.m_buffer, start, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[start + i + s] = ((AttributeStreamOfDbl)src).m_buffer[srcStart + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, double value, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        for (int i = 0; i < count; ++i) {
            this.m_buffer[start + i] = value;
        }
    }

    @Override
    public void insertAttributes(int start, Point pt, int semantics, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        int comp = VertexDescription.getComponentCount(semantics);
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + comp, validSize - start);
        for (int c = 0; c < comp; ++c) {
            this.m_buffer[start + c] = pt.getAttributeAsDbl(semantics, c);
        }
    }

    public void insert(int index, Point2D point, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, index, this.m_buffer, index + 2, validSize - index);
        this.m_buffer[index] = point.x;
        this.m_buffer[index + 1] = point.y;
    }

    public void writeRange(int streamOffset, int count, double[][] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count < 0 || arrayOffset < 0 || count > NumberUtils.intMax()) {
            throw new IllegalArgumentException();
        }
        if (src.length * 2 < (arrayOffset << 1) + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + streamOffset) {
            this.resize(count + streamOffset);
        }
        int j = streamOffset;
        if (!bForward) {
            j += count - 1;
        }
        int dj = bForward ? 2 : -2;
        int end = arrayOffset + (count >> 1);
        for (int i = arrayOffset; i < end; ++i) {
            this.m_buffer[j] = src[i][0];
            this.m_buffer[j + 1] = src[i][1];
            j += dj;
        }
    }

    public void writeRange(int streamOffset, int count, double[] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count < 0 || arrayOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (src.length < arrayOffset + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + streamOffset) {
            this.resize(count + streamOffset);
        }
        if (bForward) {
            System.arraycopy(src, arrayOffset, this.m_buffer, streamOffset, count);
        } else {
            int j = streamOffset;
            if (!bForward) {
                j += count - 1;
            }
            int end = arrayOffset + count;
            for (int i = arrayOffset; i < end; ++i) {
                this.m_buffer[j] = src[i];
                --j;
            }
        }
    }

    public void readRange(int streamOffset, int count, double[][] dst, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || count < 0 || arrayOffset < 0 || count > NumberUtils.intMax() || this.size() < count + streamOffset) {
            throw new IllegalArgumentException();
        }
        if (dst.length * 2 < (arrayOffset << 1) + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        int j = streamOffset;
        if (!bForward) {
            j += count - 1;
        }
        int dj = bForward ? 2 : -2;
        int end = arrayOffset + (count >> 1);
        for (int i = arrayOffset; i < end; ++i) {
            dst[i][0] = this.m_buffer[j];
            dst[i][1] = this.m_buffer[j + 1];
            j += dj;
        }
    }

    @Override
    public void eraseRange(int index, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (index + count > this.m_size) {
            throw new GeometryException("invalid_call");
        }
        if (validSize - (index + count) > 0) {
            System.arraycopy(this.m_buffer, index + count, this.m_buffer, index, validSize - (index + count));
        }
        this.m_size -= count;
    }

    @Override
    public void readRange(int srcStart, int count, ByteBuffer dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count < 0 || dstOffset < 0 || this.size() < count + srcStart) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (dst.capacity() < dstOffset + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        int j = srcStart;
        if (!bForward) {
            j += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = dstOffset;
        int i = 0;
        while (i < count) {
            dst.putDouble(offset, this.m_buffer[j]);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }

    @Override
    public void reverseRange(int index, int count, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (stride < 1 || count % stride != 0) {
            throw new GeometryException("invalid_call");
        }
        int cIterations = count >> 1;
        int n = count;
        for (int i = 0; i < cIterations; i += stride) {
            n -= stride;
            for (int s = 0; s < stride; ++s) {
                double temp = this.m_buffer[index + i + s];
                this.m_buffer[index + i + s] = this.m_buffer[index + n + s];
                this.m_buffer[index + n + s] = temp;
            }
        }
    }

    @Override
    public void setRange(double value, int start, int count) {
        if (start < 0 || count < 0 || start < 0 || count + start > this.size()) {
            throw new IllegalArgumentException();
        }
        double v = value;
        Arrays.fill(this.m_buffer, start, start + count, v);
    }

    @Override
    public void writeRange(int startElement, int count, AttributeStreamBase _src, int srcStart, boolean bForward, int stride) {
        if (startElement < 0 || count < 0 || srcStart < 0) {
            throw new IllegalArgumentException();
        }
        if (!(bForward || stride > 0 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl src = (AttributeStreamOfDbl)_src;
        if (src.size() < srcStart + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        if (_src == this) {
            this._selfWriteRangeImpl(startElement, count, srcStart, bForward, stride);
            return;
        }
        if (bForward) {
            int j = startElement;
            int offset = srcStart;
            for (int i = 0; i < count; ++i) {
                this.m_buffer[j] = src.m_buffer[offset];
                ++j;
                ++offset;
            }
        } else {
            int j = startElement;
            int offset = srcStart + count - stride;
            if (stride == 1) {
                for (int i = 0; i < count; ++i) {
                    this.m_buffer[j] = src.m_buffer[offset];
                    ++j;
                    --offset;
                }
            } else {
                int n = count / stride;
                for (int i = 0; i < n; ++i) {
                    for (int k = 0; k < stride; ++k) {
                        this.m_buffer[j + k] = src.m_buffer[offset + k];
                    }
                    j += stride;
                    offset -= stride;
                }
            }
        }
    }

    private void _selfWriteRangeImpl(int toElement, int count, int fromElement, boolean bForward, int stride) {
        if (bForward && toElement == fromElement) {
            return;
        }
        System.arraycopy(this.m_buffer, fromElement, this.m_buffer, toElement, count);
        if (bForward) {
            return;
        }
        int j = toElement;
        int offset = toElement + count - stride;
        int dj = stride;
        int n = count / 2;
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < stride; ++k) {
                double v = this.m_buffer[j + k];
                this.m_buffer[j + k] = this.m_buffer[offset + k];
                this.m_buffer[offset + k] = v;
            }
            j += stride;
            offset -= stride;
        }
    }

    @Override
    public void writeRange(int startElement, int count, ByteBuffer src, int offsetBytes, boolean bForward) {
        if (startElement < 0 || count < 0 || offsetBytes < 0) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (src.capacity() < offsetBytes + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        int j = startElement;
        if (!bForward) {
            j += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = offsetBytes;
        int i = 0;
        while (i < count) {
            this.m_buffer[j] = src.getDouble(offset);
            j += dj;
            ++i;
            offset += elmSize;
        }
    }

    public void writeRange(int streamOffset, int pointCount, Point2D[] src, int arrayOffset, boolean bForward) {
        if (streamOffset < 0 || pointCount < 0 || arrayOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (pointCount == 0) {
            return;
        }
        if (this.size() < (pointCount << 1) + streamOffset) {
            this.resize((pointCount << 1) + streamOffset);
        }
        int j = streamOffset;
        if (!bForward) {
            j += pointCount - 1 << 1;
        }
        int dj = bForward ? 2 : -2;
        int i0 = arrayOffset;
        pointCount += i0;
        for (int i = i0; i < pointCount; ++i) {
            this.m_buffer[j] = src[i].x;
            this.m_buffer[j + 1] = src[i].y;
            j += dj;
        }
    }

    public void readRange(int srcStart, int count, double[] dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count < 0 || dstOffset < 0 || this.size() < count + srcStart) {
            throw new IllegalArgumentException();
        }
        if (bForward) {
            System.arraycopy(this.m_buffer, srcStart, dst, dstOffset, count);
        } else {
            int j = dstOffset + count - 1;
            for (int i = srcStart; i < count; ++i) {
                dst[j] = this.m_buffer[i];
                --j;
            }
        }
    }

    public void sort(int start, int end) {
        Arrays.sort(this.m_buffer, start, end);
    }
}

