/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.jackson.databind.jsontype.impl;

import com.datastax.shaded.jackson.annotation.JsonTypeInfo;
import com.datastax.shaded.jackson.databind.DatabindContext;
import com.datastax.shaded.jackson.databind.DeserializationConfig;
import com.datastax.shaded.jackson.databind.DeserializationFeature;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.cfg.MapperConfig;
import com.datastax.shaded.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.datastax.shaded.jackson.databind.type.TypeFactory;
import com.datastax.shaded.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> type, String name) {
    }

    @Override
    public String idFromValue(Object value) {
        return this._idFrom(value, value.getClass());
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        return this._idFrom(value, type);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String id) {
        return this._typeFromId(id, null);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        return this._typeFromId(id, context);
    }

    protected JavaType _typeFromId(String id, DatabindContext ctxt) {
        Class<?> cls;
        TypeFactory tf;
        TypeFactory typeFactory = tf = ctxt == null ? this._typeFactory : ctxt.getTypeFactory();
        if (id.indexOf(60) > 0) {
            JavaType t = tf.constructFromCanonical(id);
            return t;
        }
        try {
            cls = tf.findClass(id);
        }
        catch (ClassNotFoundException e) {
            DeserializationConfig dc;
            MapperConfig<?> cfg = ctxt.getConfig();
            if (cfg instanceof DeserializationConfig && !(dc = (DeserializationConfig)cfg).isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return null;
            }
            throw new IllegalArgumentException("Invalid type id '" + id + "' (for id type 'Id.class'): no such class found");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type id '" + id + "' (for id type 'Id.class'): " + e.getMessage(), e);
        }
        return tf.constructSpecializedType(this._baseType, cls);
    }

    protected final String _idFrom(Object value, Class<?> cls) {
        Class<?> staticType;
        Class<?> outer;
        String str;
        if (Enum.class.isAssignableFrom(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        if ((str = cls.getName()).startsWith("java.util")) {
            if (value instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value);
                str = this._typeFactory.constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value);
                Class<Object> valueClass = Object.class;
                str = this._typeFactory.constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            } else {
                String end = str.substring(9);
                if ((end.startsWith(".Arrays$") || end.startsWith(".Collections$")) && str.indexOf("List") >= 0) {
                    str = "java.util.ArrayList";
                }
            }
        } else if (str.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str = cls.getName();
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

