/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ContinuousCqlRequestAsyncProcessor
    implements RequestProcessor<Statement<?>, CompletionStage<ContinuousAsyncResultSet>> {

  public static final GenericType<CompletionStage<ContinuousAsyncResultSet>>
      CONTINUOUS_RESULT_ASYNC = new GenericType<CompletionStage<ContinuousAsyncResultSet>>() {};

  @Override
  public boolean canProcess(Request request, GenericType<?> resultType) {
    return request instanceof Statement && resultType.equals(CONTINUOUS_RESULT_ASYNC);
  }

  @Override
  public CompletionStage<ContinuousAsyncResultSet> process(
      Statement<?> request,
      DefaultSession session,
      InternalDriverContext context,
      String sessionLogPrefix) {
    return new ContinuousCqlRequestHandler(request, session, context, sessionLogPrefix).handle();
  }

  @Override
  public CompletionStage<ContinuousAsyncResultSet> newFailure(RuntimeException error) {
    return CompletableFutures.failedFuture(error);
  }
}
