/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core;

import com.datastax.dse.driver.api.core.DseSession;
import com.datastax.dse.driver.api.core.type.codec.DseTypeCodecs;
import com.datastax.dse.driver.internal.core.config.typesafe.DefaultDseDriverConfigLoader;
import com.datastax.dse.driver.internal.core.context.DseDriverContext;
import com.datastax.dse.driver.internal.core.session.DefaultDseSession;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.session.SessionBuilder;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DseSessionBuilder
extends SessionBuilder<DseSessionBuilder, DseSession> {
    private UUID startupClientId;
    private String startupApplicationName;
    private String startupApplicationVersion;

    @NonNull
    public DseSessionBuilder withClientId(@Nullable UUID clientId) {
        this.startupClientId = clientId;
        return this;
    }

    @NonNull
    public DseSessionBuilder withApplicationName(@Nullable String applicationName) {
        this.startupApplicationName = applicationName;
        return this;
    }

    @NonNull
    public DseSessionBuilder withApplicationVersion(@Nullable String applicationVersion) {
        this.startupApplicationVersion = applicationVersion;
        return this;
    }

    @NonNull
    public DseSessionBuilder withConfigLoader(@Nullable DriverConfigLoader configLoader) {
        return (DseSessionBuilder)super.withConfigLoader(configLoader);
    }

    protected DriverContext buildContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader) {
        typeCodecs.add(DseTypeCodecs.LINE_STRING);
        typeCodecs.add(DseTypeCodecs.POINT);
        typeCodecs.add(DseTypeCodecs.POLYGON);
        typeCodecs.add(DseTypeCodecs.DATE_RANGE);
        return new DseDriverContext(configLoader, typeCodecs, nodeStateListener, schemaChangeListener, requestTracker, localDatacenters, nodeFilters, classLoader, this.startupClientId, this.startupApplicationName, this.startupApplicationVersion);
    }

    @NonNull
    protected DriverConfigLoader defaultConfigLoader() {
        return new DefaultDseDriverConfigLoader();
    }

    @NonNull
    protected DseSession wrap(@NonNull CqlSession defaultSession) {
        return new DefaultDseSession((Session)defaultSession);
    }
}

