/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.auth;

import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Map;

public class ProxyAuthentication {
    private static final String PROXY_EXECUTE = "ProxyExecute";

    @NonNull
    public static <StatementT extends Statement<StatementT>> StatementT executeAs(@NonNull String userOrRole, @NonNull StatementT statement) {
        return (StatementT)statement.setCustomPayload(ProxyAuthentication.addProxyExecuteEntry(statement.getCustomPayload(), userOrRole));
    }

    @NonNull
    public static <StatementT extends GraphStatement<StatementT>> StatementT executeAs(@NonNull String userOrRole, @NonNull StatementT statement) {
        return statement.setCustomPayload(ProxyAuthentication.addProxyExecuteEntry(statement.getCustomPayload(), userOrRole));
    }

    private static Map<String, ByteBuffer> addProxyExecuteEntry(Map<String, ByteBuffer> currentPayload, @NonNull String userOrRole) {
        NullAllowingImmutableMap.Builder builder = NullAllowingImmutableMap.builder();
        builder.put((Object)PROXY_EXECUTE, (Object)ByteBuffer.wrap(userOrRole.getBytes(Charsets.UTF_8)));
        if (!currentPayload.isEmpty()) {
            for (Map.Entry<String, ByteBuffer> entry : currentPayload.entrySet()) {
                String key = entry.getKey();
                if (key.equals(PROXY_EXECUTE)) continue;
                builder.put((Object)key, (Object)entry.getValue());
            }
        }
        return builder.build();
    }
}

