/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URL;

public class DseDriverConfigLoader {
    @NonNull
    public static DriverConfigLoader fromClasspath(@NonNull String resourceBaseName) {
        return new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            Config config = ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)resourceBaseName)).withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)"dse-reference")).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
            return config.getConfig("datastax-java-driver");
        });
    }

    @NonNull
    public static DriverConfigLoader fromFile(@NonNull File file) {
        return new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            Config config = ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)ConfigFactory.parseFileAnySyntax((File)file)).withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)"dse-reference")).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
            return config.getConfig("datastax-java-driver");
        });
    }

    @NonNull
    public static DriverConfigLoader fromUrl(@NonNull URL url) {
        return new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            Config config = ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)ConfigFactory.parseURL((URL)url)).withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)"dse-reference")).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
            return config.getConfig("datastax-java-driver");
        });
    }

    @NonNull
    public static ProgrammaticDriverConfigLoaderBuilder programmaticBuilder() {
        return new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.defaultApplication().withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)"dse-reference")).withFallback((ConfigMergeable)ConfigFactory.defaultReference()), "datastax-java-driver");
    }

    private DseDriverConfigLoader() {
        throw new AssertionError((Object)"Not meant to be instantiated");
    }
}

