/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface GraphStatement<SelfT extends GraphStatement<SelfT>>
extends Request {
    public static final GenericType<GraphResultSet> SYNC = GenericType.of(GraphResultSet.class);
    public static final GenericType<CompletionStage<AsyncGraphResultSet>> ASYNC = new GenericType<CompletionStage<AsyncGraphResultSet>>(){};

    @NonNull
    @CheckReturnValue
    public SelfT setIdempotent(@Nullable Boolean var1);

    @Nullable
    public Duration getTimeout();

    @NonNull
    @CheckReturnValue
    public SelfT setTimeout(@Nullable Duration var1);

    @NonNull
    @CheckReturnValue
    public SelfT setNode(@Nullable Node var1);

    public long getTimestamp();

    @CheckReturnValue
    public SelfT setTimestamp(long var1);

    @NonNull
    @CheckReturnValue
    public SelfT setExecutionProfile(@Nullable DriverExecutionProfile var1);

    @NonNull
    @CheckReturnValue
    public SelfT setExecutionProfileName(@Nullable String var1);

    @NonNull
    @CheckReturnValue
    public SelfT setCustomPayload(@NonNull Map<String, ByteBuffer> var1);

    @Nullable
    public String getGraphName();

    @NonNull
    @CheckReturnValue
    public SelfT setGraphName(@Nullable String var1);

    @Nullable
    public String getTraversalSource();

    @NonNull
    @CheckReturnValue
    public SelfT setTraversalSource(@Nullable String var1);

    @Nullable
    public String getSubProtocol();

    @NonNull
    @CheckReturnValue
    public SelfT setSubProtocol(@Nullable String var1);

    @Nullable
    public ConsistencyLevel getConsistencyLevel();

    @CheckReturnValue
    public SelfT setConsistencyLevel(@Nullable ConsistencyLevel var1);

    @Nullable
    public ConsistencyLevel getReadConsistencyLevel();

    @NonNull
    @CheckReturnValue
    public SelfT setReadConsistencyLevel(@Nullable ConsistencyLevel var1);

    @Nullable
    public ConsistencyLevel getWriteConsistencyLevel();

    @NonNull
    @CheckReturnValue
    public SelfT setWriteConsistencyLevel(@Nullable ConsistencyLevel var1);

    @Nullable
    default public CqlIdentifier getKeyspace() {
        return null;
    }

    @Nullable
    default public CqlIdentifier getRoutingKeyspace() {
        return null;
    }

    @Nullable
    default public ByteBuffer getRoutingKey() {
        return null;
    }

    @Nullable
    default public Token getRoutingToken() {
        return null;
    }

    default public boolean isTracing() {
        return false;
    }
}

