/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class GraphStatementBuilderBase<SelfT extends GraphStatementBuilderBase<SelfT, StatementT>, StatementT extends GraphStatement<StatementT>> {
    private final SelfT self = this;
    protected Boolean isIdempotent;
    protected Duration timeout;
    protected Node node;
    protected long timestamp;
    protected DriverExecutionProfile executionProfile;
    protected String executionProfileName;
    private NullAllowingImmutableMap.Builder<String, ByteBuffer> customPayloadBuilder;
    protected String graphName;
    protected String traversalSource;
    protected String subProtocol;
    protected ConsistencyLevel consistencyLevel;
    protected ConsistencyLevel readConsistencyLevel;
    protected ConsistencyLevel writeConsistencyLevel;

    protected GraphStatementBuilderBase() {
    }

    protected GraphStatementBuilderBase(StatementT template) {
        this.isIdempotent = template.isIdempotent();
        this.timeout = template.getTimeout();
        this.node = template.getNode();
        this.timestamp = template.getTimestamp();
        this.executionProfile = template.getExecutionProfile();
        this.executionProfileName = template.getExecutionProfileName();
        if (!template.getCustomPayload().isEmpty()) {
            this.customPayloadBuilder = NullAllowingImmutableMap.builder().putAll(template.getCustomPayload());
        }
        this.graphName = template.getGraphName();
        this.traversalSource = template.getTraversalSource();
        this.subProtocol = template.getSubProtocol();
        this.consistencyLevel = template.getConsistencyLevel();
        this.readConsistencyLevel = template.getReadConsistencyLevel();
        this.writeConsistencyLevel = template.getWriteConsistencyLevel();
    }

    @NonNull
    public SelfT setIdempotence(@Nullable Boolean idempotent) {
        this.isIdempotent = idempotent;
        return this.self;
    }

    @NonNull
    public SelfT setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this.self;
    }

    @NonNull
    public SelfT setNode(@Nullable Node node) {
        this.node = node;
        return this.self;
    }

    @NonNull
    public SelfT setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this.self;
    }

    @NonNull
    public SelfT setExecutionProfileName(@Nullable String executionProfileName) {
        this.executionProfileName = executionProfileName;
        return this.self;
    }

    @NonNull
    public SelfT setExecutionProfile(@Nullable DriverExecutionProfile executionProfile) {
        this.executionProfile = executionProfile;
        this.executionProfileName = null;
        return this.self;
    }

    @NonNull
    public SelfT addCustomPayload(@NonNull String key, @Nullable ByteBuffer value) {
        if (this.customPayloadBuilder == null) {
            this.customPayloadBuilder = NullAllowingImmutableMap.builder();
        }
        this.customPayloadBuilder.put((Object)key, (Object)value);
        return this.self;
    }

    @NonNull
    public SelfT clearCustomPayload() {
        this.customPayloadBuilder = null;
        return this.self;
    }

    @NonNull
    public SelfT setGraphName(@Nullable String graphName) {
        this.graphName = graphName;
        return this.self;
    }

    @NonNull
    public SelfT setTraversalSource(@Nullable String traversalSource) {
        this.traversalSource = traversalSource;
        return this.self;
    }

    @NonNull
    public SelfT setSubProtocol(@Nullable String subProtocol) {
        this.subProtocol = subProtocol;
        return this.self;
    }

    @NonNull
    public SelfT setConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this.self;
    }

    @NonNull
    public SelfT setReadConsistencyLevel(@Nullable ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
        return this.self;
    }

    @NonNull
    public SelfT setWriteConsistencyLevel(@Nullable ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
        return this.self;
    }

    @NonNull
    protected Map<String, ByteBuffer> buildCustomPayload() {
        return this.customPayloadBuilder == null ? NullAllowingImmutableMap.of() : this.customPayloadBuilder.build();
    }

    @NonNull
    public abstract StatementT build();
}

