/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public interface DseFunctionMetadata
extends FunctionMetadata {
    public boolean isDeterministic();

    public boolean isMonotonic();

    @NonNull
    public List<CqlIdentifier> getMonotonicArgumentNames();

    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        builder.append("CREATE FUNCTION ").append(this.getKeyspace()).append(".").append(this.getSignature().getName()).append("(");
        boolean first = true;
        for (int i = 0; i < this.getSignature().getParameterTypes().size(); ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            DataType type = (DataType)this.getSignature().getParameterTypes().get(i);
            CqlIdentifier name = (CqlIdentifier)this.getParameterNames().get(i);
            builder.append(name).append(" ").append(type.asCql(false, pretty));
        }
        builder.append(")").increaseIndent().newLine().append(this.isCalledOnNullInput() ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT").newLine().append("RETURNS ").append(this.getReturnType().asCql(false, true)).newLine();
        if (this.isDeterministic()) {
            builder.append("DETERMINISTIC").newLine();
        }
        if (this.isMonotonic()) {
            builder.append("MONOTONIC").newLine();
        } else if (!this.getMonotonicArgumentNames().isEmpty()) {
            builder.append("MONOTONIC ON ").append(this.getMonotonicArgumentNames().get(0)).newLine();
        }
        builder.append("LANGUAGE ").append(this.getLanguage()).newLine().append("AS '").append(this.getBody()).append("';");
        return builder.build();
    }
}

