/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.DseProtocolFeature;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.CassandraProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseProtocolVersionRegistry
extends CassandraProtocolVersionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DseProtocolVersionRegistry.class);
    @VisibleForTesting
    static final Version DSE_4_7_0 = Version.parse((String)"4.7.0");
    @VisibleForTesting
    static final Version DSE_5_0_0 = Version.parse((String)"5.0.0");
    @VisibleForTesting
    static final Version DSE_5_1_0 = Version.parse((String)"5.1.0");
    @VisibleForTesting
    static final Version DSE_6_0_0 = Version.parse((String)"6.0.0");
    private final String logPrefix;

    public DseProtocolVersionRegistry(String logPrefix) {
        super(logPrefix, (ProtocolVersion[][])new ProtocolVersion[][]{DefaultProtocolVersion.values(), DseProtocolVersion.values()});
        this.logPrefix = logPrefix;
    }

    public ProtocolVersion highestCommon(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one node");
        }
        HashSet candidates = new HashSet();
        candidates.addAll(DseProtocolVersionRegistry.allNonBeta((Enum[])DefaultProtocolVersion.values()));
        candidates.addAll(DseProtocolVersionRegistry.allNonBeta((Enum[])DseProtocolVersion.values()));
        for (Node node : nodes) {
            ImmutableList toEliminate = Collections.emptyList();
            Version dseVersion = (Version)node.getExtras().get("DSE_VERSION");
            if (dseVersion != null) {
                LOG.debug("[{}] Node {} reports DSE version {}", new Object[]{this.logPrefix, node.getEndPoint(), dseVersion});
                dseVersion = dseVersion.nextStable();
                if (dseVersion.compareTo(DSE_4_7_0) < 0) {
                    throw new UnsupportedProtocolVersionException(node.getEndPoint(), String.format("Node %s reports DSE version %s, but the driver only supports 4.7.0 and above", node.getEndPoint(), dseVersion), DseProtocolVersionRegistry.triedVersionsForHighestCommon());
                }
                if (dseVersion.compareTo(DSE_5_0_0) < 0) {
                    toEliminate = ImmutableList.of((Object)DefaultProtocolVersion.V4, (Object)((Object)DseProtocolVersion.DSE_V1), (Object)((Object)DseProtocolVersion.DSE_V2));
                } else if (dseVersion.compareTo(DSE_5_1_0) < 0) {
                    toEliminate = ImmutableList.of((Object)((Object)DseProtocolVersion.DSE_V1), (Object)((Object)DseProtocolVersion.DSE_V2));
                } else if (dseVersion.compareTo(DSE_6_0_0) < 0) {
                    toEliminate = ImmutableList.of((Object)((Object)DseProtocolVersion.DSE_V2));
                }
            } else {
                Version cassandraVersion = node.getCassandraVersion();
                if (cassandraVersion == null) {
                    LOG.warn("[{}] Node {} reports neither DSE version nor Cassandra version, ignoring it from optimal protocol version computation", (Object)this.logPrefix, (Object)node.getEndPoint());
                    continue;
                }
                if ((cassandraVersion = cassandraVersion.nextStable()).compareTo(Version.V2_1_0) < 0) {
                    throw new UnsupportedProtocolVersionException(node.getEndPoint(), String.format("Node %s reports Cassandra version %s, but the driver only supports 2.1.0 and above", node.getEndPoint(), cassandraVersion), (List)ImmutableList.of((Object)DefaultProtocolVersion.V3, (Object)DefaultProtocolVersion.V4));
                }
                LOG.debug("[{}] Node {} reports Cassandra version {}", new Object[]{this.logPrefix, node.getEndPoint(), cassandraVersion});
                toEliminate = cassandraVersion.compareTo(Version.V2_2_0) < 0 ? ImmutableList.of((Object)DefaultProtocolVersion.V4, (Object)((Object)DseProtocolVersion.DSE_V1), (Object)((Object)DseProtocolVersion.DSE_V2)) : ImmutableList.of((Object)((Object)DseProtocolVersion.DSE_V1), (Object)((Object)DseProtocolVersion.DSE_V2));
            }
            for (ProtocolVersion version : toEliminate) {
                if (!candidates.remove(version)) continue;
                LOG.debug("[{}] Excluding protocol {}", (Object)this.logPrefix, (Object)version);
            }
        }
        ProtocolVersion max = null;
        for (ProtocolVersion candidate : candidates) {
            if (max != null && max.getCode() >= candidate.getCode()) continue;
            max = candidate;
        }
        if (max == null) {
            throw new UnsupportedProtocolVersionException(null, String.format("Could not determine a common protocol version, enable DEBUG logs for '%s' for more details", LOG.getName()), DseProtocolVersionRegistry.triedVersionsForHighestCommon());
        }
        return max;
    }

    private static ImmutableList<ProtocolVersion> triedVersionsForHighestCommon() {
        return ImmutableList.builder().addAll((Iterable)DseProtocolVersionRegistry.allNonBeta((Enum[])DefaultProtocolVersion.values())).addAll((Iterable)DseProtocolVersionRegistry.allNonBeta((Enum[])DseProtocolVersion.values())).build();
    }

    private static <T extends Enum<T>> Collection<T> allNonBeta(T[] versions) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (T version : versions) {
            if (((ProtocolVersion)version).isBeta()) continue;
            result.add(version);
        }
        return result.build();
    }

    public boolean supports(ProtocolVersion version, ProtocolFeature feature) {
        int code = version.getCode();
        if (DefaultProtocolFeature.UNSET_BOUND_VALUES.equals((Object)feature)) {
            return DefaultProtocolVersion.V4.getCode() <= code;
        }
        if (DefaultProtocolFeature.PER_REQUEST_KEYSPACE.equals((Object)feature)) {
            return DefaultProtocolVersion.V5.getCode() <= code && code < DseProtocolVersion.DSE_V1.getCode() || DseProtocolVersion.DSE_V2.getCode() <= code;
        }
        if (DseProtocolFeature.CONTINUOUS_PAGING.equals(feature)) {
            return DseProtocolVersion.DSE_V1.getCode() <= code;
        }
        throw new IllegalArgumentException("Unhandled protocol feature: " + feature);
    }
}

