/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.context.DseDriverContext;
import com.datastax.dse.driver.internal.core.insights.InsightsClient;
import com.datastax.dse.driver.internal.core.insights.configuration.InsightsConfiguration;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.LifecycleListener;

public class InsightsClientLifecycleListener
implements LifecycleListener {
    private static final boolean DEFAULT_INSIGHTS_ENABLED = true;
    private static final long STATUS_EVENT_DELAY_MILLIS = 300000L;
    private final DseDriverContext context;
    private final StackTraceElement[] initCallStackTrace;
    private volatile InsightsClient insightsClient;

    public InsightsClientLifecycleListener(DseDriverContext context, StackTraceElement[] initCallStackTrace) {
        this.context = context;
        this.initCallStackTrace = initCallStackTrace;
    }

    public void onSessionReady() {
        boolean monitorReportingEnabled = this.context.getConfig().getDefaultProfile().getBoolean((DriverOption)DseDriverOption.MONITOR_REPORTING_ENABLED, true);
        this.insightsClient = InsightsClient.createInsightsClient(new InsightsConfiguration(monitorReportingEnabled, 300000L, this.context.getNettyOptions().adminEventExecutorGroup().next()), this.context, this.initCallStackTrace);
        this.insightsClient.sendStartupMessage();
        this.insightsClient.scheduleStatusMessageSend();
    }

    public void close() {
        if (this.insightsClient != null) {
            this.insightsClient.shutdown();
        }
    }
}

