/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.auth;

import com.datastax.oss.driver.api.core.auth.SyncAuthenticator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class BaseDseAuthenticator
implements SyncAuthenticator {
    private static final String DSE_AUTHENTICATOR = "com.datastax.bdp.cassandra.auth.DseAuthenticator";
    private final String serverAuthenticator;

    BaseDseAuthenticator(@NonNull String serverAuthenticator) {
        this.serverAuthenticator = serverAuthenticator;
    }

    @NonNull
    public abstract ByteBuffer getMechanism();

    @NonNull
    public abstract ByteBuffer getInitialServerChallenge();

    @Nullable
    public ByteBuffer initialResponseSync() {
        if (this.isDseAuthenticator()) {
            return this.getMechanism();
        }
        return this.evaluateChallengeSync(this.getInitialServerChallenge());
    }

    public void onAuthenticationSuccessSync(@Nullable ByteBuffer token) {
    }

    private boolean isDseAuthenticator() {
        return this.serverAuthenticator.equals(DSE_AUTHENTICATOR);
    }
}

