/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.auth;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.auth.AuthUtils;
import com.datastax.dse.driver.internal.core.auth.BaseDseAuthenticator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DseGssApiAuthProvider
implements AuthProvider {
    public static final String DEFAULT_SASL_SERVICE_NAME = "dse";
    public static final String SASL_SERVICE_NAME_PROPERTY = "dse.sasl.service";
    private final DriverExecutionProfile config;

    public DseGssApiAuthProvider(DriverContext context) {
        this.config = context.getConfig().getDefaultProfile();
    }

    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) throws AuthenticationException {
        String authorizationId = null;
        String saslService = null;
        Map saslPropertiesMap = new HashMap();
        AuthUtils.validateConfigPresent(this.config, DseGssApiAuthProvider.class.getName(), endPoint, DseDriverOption.AUTH_PROVIDER_LOGIN_CONFIGURATION);
        if (this.config.isDefined((DriverOption)DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID)) {
            authorizationId = this.config.getString((DriverOption)DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID);
        }
        if (this.config.isDefined((DriverOption)DseDriverOption.AUTH_PROVIDER_SERVICE)) {
            saslService = this.config.getString((DriverOption)DseDriverOption.AUTH_PROVIDER_SERVICE);
        }
        if (this.config.isDefined((DriverOption)DseDriverOption.AUTH_PROVIDER_SASL_PROPERTIES)) {
            saslPropertiesMap = this.config.getStringMap((DriverOption)DseDriverOption.AUTH_PROVIDER_SASL_PROPERTIES);
        }
        Map loginConfigurationMap = this.config.getStringMap((DriverOption)DseDriverOption.AUTH_PROVIDER_LOGIN_CONFIGURATION);
        Configuration loginConfiguration = DseGssApiAuthProvider.fetchLoginConfiguration(loginConfigurationMap);
        return new GssApiAuthenticator(serverAuthenticator, authorizationId, endPoint, loginConfiguration, saslService, saslPropertiesMap);
    }

    public void onMissingChallenge(@NonNull EndPoint endPoint) {
    }

    public void close() throws Exception {
    }

    public static Configuration fetchLoginConfiguration(final Map<String, String> options) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
    }

    private static class GssApiAuthenticator
    extends BaseDseAuthenticator {
        private static final String JAAS_CONFIG_ENTRY = "DseClient";
        private static final String[] SUPPORTED_MECHANISMS = new String[]{"GSSAPI"};
        private static final Map<String, String> DEFAULT_PROPERTIES = ImmutableMap.builder().put((Object)"javax.security.sasl.server.authentication", (Object)"true").put((Object)"javax.security.sasl.qop", (Object)"auth").build();
        private static final ByteBuffer EMPTY_BYTE_ARRAY = ByteBuffer.wrap(new byte[0]).asReadOnlyBuffer();
        private static final ByteBuffer MECHANISM = ByteBuffer.wrap("GSSAPI".getBytes(Charsets.UTF_8)).asReadOnlyBuffer();
        private static final ByteBuffer SERVER_INITIAL_CHALLENGE = ByteBuffer.wrap("GSSAPI-START".getBytes(Charsets.UTF_8)).asReadOnlyBuffer();
        private Subject subject;
        private SaslClient saslClient;
        private EndPoint endPoint;

        private GssApiAuthenticator(String authenticator, String authorizationId, EndPoint endPoint, Configuration loginConfiguration, String saslService, Map<String, String> saslProperties) {
            super(authenticator);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(saslProperties);
            DEFAULT_PROPERTIES.forEach((k, v) -> {
                if (!saslProperties.containsKey(k)) {
                    builder.put(k, v);
                }
            });
            ImmutableMap finalSaslProperties = builder.build();
            try {
                this.endPoint = endPoint;
                String protocol = saslService;
                if (protocol == null) {
                    protocol = System.getProperty(DseGssApiAuthProvider.SASL_SERVICE_NAME_PROPERTY, DseGssApiAuthProvider.DEFAULT_SASL_SERVICE_NAME);
                }
                LoginContext login = new LoginContext(JAAS_CONFIG_ENTRY, null, null, loginConfiguration);
                login.login();
                this.subject = login.getSubject();
                this.saslClient = Sasl.createSaslClient(SUPPORTED_MECHANISMS, authorizationId, protocol, ((InetSocketAddress)endPoint.resolve()).getAddress().getCanonicalHostName(), finalSaslProperties, null);
            }
            catch (LoginException | SaslException e) {
                throw new AuthenticationException(endPoint, e.getMessage());
            }
        }

        @Override
        @NonNull
        public ByteBuffer getMechanism() {
            return MECHANISM;
        }

        @Override
        @NonNull
        public ByteBuffer getInitialServerChallenge() {
            return SERVER_INITIAL_CHALLENGE;
        }

        @Nullable
        public ByteBuffer evaluateChallengeSync(@Nullable ByteBuffer challenge) {
            byte[] challengeBytes;
            if (SERVER_INITIAL_CHALLENGE.equals(challenge)) {
                if (!this.saslClient.hasInitialResponse()) {
                    return EMPTY_BYTE_ARRAY;
                }
                challengeBytes = new byte[]{};
            } else {
                if (challenge == null) {
                    throw new AuthenticationException(this.endPoint, "Unexpected null challenge from server");
                }
                challengeBytes = Bytes.getArray((ByteBuffer)challenge);
            }
            try {
                return ByteBuffer.wrap(Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return saslClient.evaluateChallenge(challengeBytes);
                    }
                }));
            }
            catch (PrivilegedActionException e) {
                throw new AuthenticationException(this.endPoint, e.getMessage(), (Throwable)e.getException());
            }
        }
    }
}

