/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.auth;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.auth.AuthUtils;
import com.datastax.dse.driver.internal.core.auth.BaseDseAuthenticator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.primitives.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DsePlainTextAuthProvider
implements AuthProvider {
    private final DriverExecutionProfile config;

    public DsePlainTextAuthProvider(DriverContext context) {
        this.config = context.getConfig().getDefaultProfile();
    }

    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) throws AuthenticationException {
        String authorizationId = this.config.isDefined((DriverOption)DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID) ? this.config.getString((DriverOption)DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID) : "";
        AuthUtils.validateConfigPresent(this.config, DsePlainTextAuthProvider.class.getName(), endPoint, new DriverOption[]{DefaultDriverOption.AUTH_PROVIDER_USER_NAME, DefaultDriverOption.AUTH_PROVIDER_PASSWORD});
        return new PlainTextAuthenticator(serverAuthenticator, this.config.getString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME), this.config.getString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD), authorizationId, endPoint);
    }

    public void onMissingChallenge(@NonNull EndPoint endPoint) {
    }

    public void close() throws Exception {
    }

    private static class PlainTextAuthenticator
    extends BaseDseAuthenticator {
        private static final ByteBuffer MECHANISM = ByteBuffer.wrap("PLAIN".getBytes(StandardCharsets.UTF_8)).asReadOnlyBuffer();
        private static final ByteBuffer SERVER_INITIAL_CHALLENGE = ByteBuffer.wrap("PLAIN-START".getBytes(StandardCharsets.UTF_8)).asReadOnlyBuffer();
        private static final byte[] NULL = new byte[]{0};
        private final byte[] authenticationId;
        private final byte[] password;
        private final byte[] authorizationId;
        private EndPoint endPoint;

        PlainTextAuthenticator(String serverAuthenticator, String authenticationId, String password, String authorizationId, EndPoint endPoint) {
            super(serverAuthenticator);
            this.authenticationId = authenticationId.getBytes(StandardCharsets.UTF_8);
            this.password = password.getBytes(StandardCharsets.UTF_8);
            this.authorizationId = authorizationId.getBytes(StandardCharsets.UTF_8);
            this.endPoint = endPoint;
        }

        @Override
        @NonNull
        public ByteBuffer getMechanism() {
            return MECHANISM;
        }

        @Override
        @NonNull
        public ByteBuffer getInitialServerChallenge() {
            return SERVER_INITIAL_CHALLENGE;
        }

        @Nullable
        public ByteBuffer evaluateChallengeSync(@Nullable ByteBuffer challenge) {
            if (SERVER_INITIAL_CHALLENGE.equals(challenge)) {
                return ByteBuffer.wrap(Bytes.concat((byte[][])new byte[][]{this.authorizationId, NULL, this.authenticationId, NULL, this.password}));
            }
            throw new AuthenticationException(this.endPoint, "Incorrect challenge from server");
        }
    }
}

