/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.context;

import com.datastax.dse.driver.api.core.config.DseDriverConfigLoader;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.DseProtocolVersionRegistry;
import com.datastax.dse.driver.internal.core.InsightsClientLifecycleListener;
import com.datastax.dse.driver.internal.core.context.DseStartupOptionsBuilder;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestSyncProcessor;
import com.datastax.dse.driver.internal.core.cql.continuous.reactive.ContinuousCqlRequestReactiveProcessor;
import com.datastax.dse.driver.internal.core.cql.reactive.CqlRequestReactiveProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphRequestSyncProcessor;
import com.datastax.dse.driver.internal.core.metadata.DseTopologyMonitor;
import com.datastax.dse.driver.internal.core.metadata.schema.parsing.DseSchemaParserFactory;
import com.datastax.dse.driver.internal.core.metadata.schema.queries.DseSchemaQueriesFactory;
import com.datastax.dse.driver.internal.core.metadata.token.DseReplicationStrategyFactory;
import com.datastax.dse.driver.internal.core.metrics.DseDropwizardMetricsFactory;
import com.datastax.dse.driver.internal.core.tracker.MultiplexingRequestTracker;
import com.datastax.dse.protocol.internal.DseProtocolV1ClientCodecs;
import com.datastax.dse.protocol.internal.DseProtocolV2ClientCodecs;
import com.datastax.dse.protocol.internal.ProtocolV4ClientCodecsForDse;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.LifecycleListener;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareSyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlRequestAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlRequestSyncProcessor;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.RequestProcessorRegistry;
import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolV3ClientCodecs;
import com.datastax.oss.protocol.internal.ProtocolV5ClientCodecs;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseDriverContext
extends DefaultDriverContext {
    private static final Logger LOG = LoggerFactory.getLogger(DseDriverContext.class);
    private final UUID startupClientId;
    private final String startupApplicationName;
    private final String startupApplicationVersion;
    private final List<LifecycleListener> listeners;

    public DseDriverContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader, UUID clientId, String applicationName, String applicationVersion) {
        super(configLoader, typeCodecs, nodeStateListener, schemaChangeListener, requestTracker, localDatacenters, nodeFilters, classLoader);
        this.startupClientId = clientId;
        this.startupApplicationName = applicationName;
        this.startupApplicationVersion = applicationVersion;
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        try {
            stackTrace = Thread.currentThread().getStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners = Collections.singletonList(new InsightsClientLifecycleListener(this, stackTrace));
        if (!this.getConfig().getDefaultProfile().isDefined((DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE)) {
            LOG.warn("[{}] It looks like your configuration is missing DSE-specific options. If you use a built-in config loader, make sure you create it with {}.", (Object)this.getSessionName(), (Object)DseDriverConfigLoader.class.getSimpleName());
        }
    }

    protected ProtocolVersionRegistry buildProtocolVersionRegistry() {
        return new DseProtocolVersionRegistry(this.getSessionName());
    }

    protected FrameCodec<ByteBuf> buildFrameCodec() {
        return new FrameCodec((PrimitiveCodec)new ByteBufPrimitiveCodec(this.getNettyOptions().allocator()), this.getCompressor(), new FrameCodec.CodecGroup[]{new ProtocolV3ClientCodecs(), new ProtocolV4ClientCodecsForDse(), new ProtocolV5ClientCodecs(), new DseProtocolV1ClientCodecs(), new DseProtocolV2ClientCodecs()});
    }

    protected RequestProcessorRegistry buildRequestProcessorRegistry() {
        String logPrefix = this.getSessionName();
        CqlRequestAsyncProcessor cqlRequestAsyncProcessor = new CqlRequestAsyncProcessor();
        CqlRequestSyncProcessor cqlRequestSyncProcessor = new CqlRequestSyncProcessor(cqlRequestAsyncProcessor);
        CqlPrepareAsyncProcessor cqlPrepareAsyncProcessor = new CqlPrepareAsyncProcessor();
        CqlPrepareSyncProcessor cqlPrepareSyncProcessor = new CqlPrepareSyncProcessor(cqlPrepareAsyncProcessor);
        ContinuousCqlRequestAsyncProcessor continuousCqlRequestAsyncProcessor = new ContinuousCqlRequestAsyncProcessor();
        ContinuousCqlRequestSyncProcessor continuousCqlRequestSyncProcessor = new ContinuousCqlRequestSyncProcessor(continuousCqlRequestAsyncProcessor);
        GraphRequestAsyncProcessor graphRequestAsyncProcessor = new GraphRequestAsyncProcessor();
        GraphRequestSyncProcessor graphRequestSyncProcessor = new GraphRequestSyncProcessor(graphRequestAsyncProcessor);
        CqlRequestReactiveProcessor cqlRequestReactiveProcessor = new CqlRequestReactiveProcessor(cqlRequestAsyncProcessor);
        ContinuousCqlRequestReactiveProcessor continuousCqlRequestReactiveProcessor = new ContinuousCqlRequestReactiveProcessor(continuousCqlRequestAsyncProcessor);
        return new RequestProcessorRegistry(logPrefix, new RequestProcessor[]{cqlRequestSyncProcessor, cqlRequestAsyncProcessor, cqlPrepareSyncProcessor, cqlPrepareAsyncProcessor, cqlRequestReactiveProcessor, continuousCqlRequestSyncProcessor, continuousCqlRequestAsyncProcessor, continuousCqlRequestReactiveProcessor, graphRequestAsyncProcessor, graphRequestSyncProcessor});
    }

    protected TopologyMonitor buildTopologyMonitor() {
        return new DseTopologyMonitor((InternalDriverContext)this);
    }

    protected ReplicationStrategyFactory buildReplicationStrategyFactory() {
        return new DseReplicationStrategyFactory((InternalDriverContext)this);
    }

    protected SchemaQueriesFactory buildSchemaQueriesFactory() {
        return new DseSchemaQueriesFactory((InternalDriverContext)this);
    }

    protected SchemaParserFactory buildSchemaParserFactory() {
        return new DseSchemaParserFactory((InternalDriverContext)this);
    }

    protected MetricsFactory buildMetricsFactory() {
        return new DseDropwizardMetricsFactory((InternalDriverContext)this);
    }

    protected Map<String, String> buildStartupOptions() {
        return new DseStartupOptionsBuilder((InternalDriverContext)this).withClientId(this.startupClientId).withApplicationName(this.startupApplicationName).withApplicationVersion(this.startupApplicationVersion).build();
    }

    protected RequestTracker buildRequestTracker(RequestTracker requestTrackerFromBuilder) {
        RequestTracker requestTrackerFromConfig = super.buildRequestTracker(requestTrackerFromBuilder);
        if (requestTrackerFromConfig instanceof MultiplexingRequestTracker) {
            return requestTrackerFromConfig;
        }
        MultiplexingRequestTracker multiplexingRequestTracker = new MultiplexingRequestTracker();
        multiplexingRequestTracker.register(requestTrackerFromConfig);
        return multiplexingRequestTracker;
    }

    @NonNull
    public List<LifecycleListener> getLifecycleListeners() {
        return this.listeners;
    }

    protected Map<String, LoadBalancingPolicy> buildLoadBalancingPolicies() {
        return Reflection.buildFromConfigProfiles((InternalDriverContext)this, (DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY, LoadBalancingPolicy.class, (String[])new String[]{"com.datastax.oss.driver.internal.core.loadbalancing", "com.datastax.dse.driver.internal.core.loadbalancing"});
    }

    protected Optional<AuthProvider> buildAuthProvider() {
        return Reflection.buildFromConfig((InternalDriverContext)this, (DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS, AuthProvider.class, (String[])new String[]{"com.datastax.oss.driver.internal.core.auth", "com.datastax.dse.driver.internal.core.auth"});
    }
}

