/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.context;

import com.datastax.dse.driver.api.core.DseSession;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.StartupOptionsBuilder;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.UUID;

public class DseStartupOptionsBuilder
extends StartupOptionsBuilder {
    public static final String APPLICATION_NAME_KEY = "APPLICATION_NAME";
    public static final String APPLICATION_VERSION_KEY = "APPLICATION_VERSION";
    public static final String CLIENT_ID_KEY = "CLIENT_ID";
    private UUID clientId;
    private String applicationName;
    private String applicationVersion;

    public DseStartupOptionsBuilder(InternalDriverContext context) {
        super(context);
    }

    protected String getDriverVersion() {
        return DseSession.DSE_DRIVER_COORDINATES.getVersion().toString();
    }

    protected String getDriverName() {
        return DseSession.DSE_DRIVER_COORDINATES.getName();
    }

    public DseStartupOptionsBuilder withClientId(@Nullable UUID clientId) {
        this.clientId = clientId;
        return this;
    }

    public DseStartupOptionsBuilder withApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public DseStartupOptionsBuilder withApplicationVersion(@Nullable String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    public Map<String, String> build() {
        DriverExecutionProfile config = this.context.getConfig().getDefaultProfile();
        if (this.clientId == null) {
            this.clientId = Uuids.random();
        }
        if (this.applicationName == null) {
            this.applicationName = config.getString((DriverOption)DseDriverOption.APPLICATION_NAME, null);
        }
        if (this.applicationVersion == null) {
            this.applicationVersion = config.getString((DriverOption)DseDriverOption.APPLICATION_VERSION, null);
        }
        NullAllowingImmutableMap.Builder builder = NullAllowingImmutableMap.builder().putAll(super.build());
        builder.put((Object)CLIENT_ID_KEY, (Object)this.clientId.toString());
        if (this.applicationName != null) {
            builder.put((Object)APPLICATION_NAME_KEY, (Object)this.applicationName);
        }
        if (this.applicationVersion != null) {
            builder.put((Object)APPLICATION_VERSION_KEY, (Object)this.applicationVersion);
        }
        return builder.build();
    }
}

