/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.DefaultReactiveResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.FailedReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlRequestAsyncProcessor;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlRequestReactiveProcessor
implements RequestProcessor<Statement<?>, ReactiveResultSet> {
    public static final GenericType<ReactiveResultSet> REACTIVE_RESULT_SET = GenericType.of(ReactiveResultSet.class);
    private final CqlRequestAsyncProcessor asyncProcessor;

    public CqlRequestReactiveProcessor(CqlRequestAsyncProcessor asyncProcessor) {
        this.asyncProcessor = asyncProcessor;
    }

    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof Statement && resultType.equals(REACTIVE_RESULT_SET);
    }

    public ReactiveResultSet process(Statement<?> request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        return new DefaultReactiveResultSet(() -> this.asyncProcessor.process(request, session, context, sessionLogPrefix));
    }

    public ReactiveResultSet newFailure(RuntimeException error) {
        return new FailedReactiveResultSet(error);
    }
}

