/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultAsyncGraphResultSet
implements AsyncGraphResultSet {
    private final GraphExecutionInfo executionInfo;
    private final CountingIterator<GraphNode> iterator;
    private final Iterable<GraphNode> currentPage;

    public DefaultAsyncGraphResultSet(GraphExecutionInfo executionInfo, Queue<GraphNode> data) {
        this.executionInfo = executionInfo;
        this.iterator = new GraphResultIterator(data);
        this.currentPage = () -> this.iterator;
    }

    @Override
    @NonNull
    public GraphExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    public int remaining() {
        return this.iterator.remaining();
    }

    @Override
    @NonNull
    public Iterable<GraphNode> currentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasMorePages() {
        return false;
    }

    @Override
    @NonNull
    public CompletionStage<AsyncGraphResultSet> fetchNextPage() throws IllegalStateException {
        throw new IllegalStateException("No next page. Use #hasMorePages before calling this method to avoid this error.");
    }

    @Override
    public void cancel() {
    }

    private static class GraphResultIterator
    extends CountingIterator<GraphNode> {
        private final Queue<GraphNode> data;
        private long repeat = 0L;
        private GraphNode lastGraphNode = null;

        private GraphResultIterator(Queue<GraphNode> data) {
            super(data.size());
            this.data = data;
        }

        protected GraphNode computeNext() {
            if (this.repeat > 1L) {
                --this.repeat;
                return this.lastGraphNode;
            }
            GraphNode container = this.data.poll();
            if (container == null) {
                return (GraphNode)this.endOfData();
            }
            GraphNode b = container.getByKey("bulk");
            if (b != null) {
                this.repeat = b.asLong();
            }
            this.lastGraphNode = container.getByKey("result");
            return this.lastGraphNode;
        }
    }
}

