/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.DseSession;
import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.DseGraphTraversal;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.Immutable;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

@Immutable
public class DseGraphRemoteConnection
implements RemoteConnection {
    private final DseSession dseSession;
    private final DriverExecutionProfile executionProfile;
    private final String executionProfileName;

    public DseGraphRemoteConnection(DseSession dseSession, DriverExecutionProfile executionProfile, String executionProfileName) {
        this.dseSession = dseSession;
        this.executionProfile = executionProfile;
        this.executionProfileName = executionProfileName;
    }

    public <E> Iterator<Traverser.Admin<E>> submit(Traversal<?, E> traversal) throws RemoteConnectionException {
        return this.submit(traversal.asAdmin().getBytecode());
    }

    public <E> RemoteTraversal<?, E> submit(Bytecode bytecode) throws RemoteConnectionException {
        try {
            return this.submitAsync(bytecode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RemoteConnectionException((Throwable)e);
        }
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        return this.dseSession.executeAsync(new BytecodeGraphStatement(bytecode, this.executionProfile, this.executionProfileName)).toCompletableFuture().thenApply(DseGraphTraversal::new);
    }

    public void close() throws Exception {
    }
}

