/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.protocol.internal.request.RawBytesQuery;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public class GraphConversions
extends Conversions {
    static String GRAPH_LANG_OPTION_KEY = "graph-language";
    static String GRAPH_NAME_OPTION_KEY = "graph-name";
    static String GRAPH_SOURCE_OPTION_KEY = "graph-source";
    static String GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY = "graph-read-consistency";
    static String GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY = "graph-write-consistency";
    static String GRAPH_RESULTS_OPTION_KEY = "graph-results";
    static String GRAPH_TIMEOUT_OPTION_KEY = "request-timeout";

    static String inferSubProtocol(GraphStatement<?> statement, DriverExecutionProfile config, DefaultSession session) {
        String graphProtocol = statement.getSubProtocol();
        if (graphProtocol == null) {
            graphProtocol = config.getString((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL, "graphson-2.0");
        }
        assert (graphProtocol != null);
        return graphProtocol;
    }

    static Message createMessageFromGraphStatement(GraphStatement<?> statement, String subProtocol, DriverExecutionProfile config, InternalDriverContext context) {
        ByteBuffer encodedQueryParams;
        try {
            Map queryParams = statement instanceof ScriptGraphStatement ? ((ScriptGraphStatement)statement).getQueryParams() : Collections.emptyMap();
            encodedQueryParams = GraphSONUtils.serializeToByteBuffer(queryParams, subProtocol);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Couldn't serialize parameters for GraphStatement: " + statement, e);
        }
        int consistencyLevel = DefaultConsistencyLevel.valueOf((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode();
        long timestamp = statement.getTimestamp();
        if (timestamp == Long.MIN_VALUE) {
            timestamp = context.getTimestampGenerator().next();
        }
        DseQueryOptions queryOptions = new DseQueryOptions(consistencyLevel, Collections.singletonList(encodedQueryParams), Collections.emptyMap(), true, 50, null, 9, timestamp, null, false, null);
        if (statement instanceof ScriptGraphStatement) {
            return new Query(((ScriptGraphStatement)statement).getScript(), (QueryOptions)queryOptions);
        }
        return new RawBytesQuery(GraphConversions.getQueryBytes(statement, subProtocol), queryOptions);
    }

    private static byte[] getQueryBytes(GraphStatement<?> statement, String graphSubProtocol) {
        assert (statement instanceof FluentGraphStatement || statement instanceof BatchGraphStatement || statement instanceof BytecodeGraphStatement);
        Object toSerialize = statement instanceof FluentGraphStatement ? ((FluentGraphStatement)statement).getTraversal().asAdmin().getBytecode() : (statement instanceof BatchGraphStatement ? ((BatchGraphStatement)statement).iterator() : ((BytecodeGraphStatement)statement).getBytecode());
        try {
            return GraphSONUtils.serializeToBytes(toSerialize, graphSubProtocol);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Map<String, ByteBuffer> createCustomPayload(GraphStatement<?> statement, String subProtocol, DriverExecutionProfile config, InternalDriverContext context) {
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        NullAllowingImmutableMap.Builder payload = NullAllowingImmutableMap.builder();
        Map statementOptions = statement.getCustomPayload();
        payload.putAll(statementOptions);
        if (!statementOptions.containsKey(GRAPH_LANG_OPTION_KEY)) {
            String graphLanguage = statement instanceof ScriptGraphStatement ? "gremlin-groovy" : "bytecode-json";
            payload.put((Object)GRAPH_LANG_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)graphLanguage, protocolVersion));
        }
        if (!GraphConversions.isSystemQuery(statement, config)) {
            if (!statementOptions.containsKey(GRAPH_NAME_OPTION_KEY)) {
                String graphName = statement.getGraphName();
                if (graphName == null) {
                    graphName = config.getString((DriverOption)DseDriverOption.GRAPH_NAME, null);
                }
                if (graphName != null) {
                    payload.put((Object)GRAPH_NAME_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)graphName, protocolVersion));
                }
            }
            if (!statementOptions.containsKey(GRAPH_SOURCE_OPTION_KEY)) {
                String traversalSource = statement.getTraversalSource();
                if (traversalSource == null) {
                    traversalSource = config.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
                }
                if (traversalSource != null) {
                    payload.put((Object)GRAPH_SOURCE_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)traversalSource, protocolVersion));
                }
            }
        }
        if (!statementOptions.containsKey(GRAPH_RESULTS_OPTION_KEY)) {
            assert (subProtocol != null);
            payload.put((Object)GRAPH_RESULTS_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)subProtocol, protocolVersion));
        }
        if (!statementOptions.containsKey(GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String readClString;
            ConsistencyLevel readCl = statement.getReadConsistencyLevel();
            String string = readClString = readCl != null ? readCl.name() : config.getString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null);
            if (readClString != null) {
                payload.put((Object)GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)readClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String writeClString;
            ConsistencyLevel writeCl = statement.getWriteConsistencyLevel();
            String string = writeClString = writeCl != null ? writeCl.name() : config.getString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null);
            if (writeClString != null) {
                payload.put((Object)GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY, (Object)TypeCodecs.TEXT.encode((Object)writeClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_TIMEOUT_OPTION_KEY)) {
            Duration timeout = statement.getTimeout();
            if (timeout == null) {
                timeout = config.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, null);
            }
            if (timeout != null && !timeout.isZero()) {
                payload.put((Object)GRAPH_TIMEOUT_OPTION_KEY, (Object)TypeCodecs.BIGINT.encode(Long.valueOf(timeout.toMillis()), protocolVersion));
            }
        }
        return payload.build();
    }

    private static boolean isSystemQuery(GraphStatement<?> statement, DriverExecutionProfile config) {
        Boolean statementValue;
        if (statement instanceof ScriptGraphStatement && (statementValue = ((ScriptGraphStatement)statement).isSystemQuery()) != null) {
            return statementValue;
        }
        return config.getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false);
    }
}

