/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.DefaultAsyncGraphResultSet;
import com.datastax.dse.driver.internal.core.graph.DefaultGraphExecutionInfo;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.handler.codec.EncoderException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GraphRequestHandler
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(GraphRequestHandler.class);
    private final long startTimeNanos = System.nanoTime();
    private final String logPrefix;
    private final DefaultSession session;
    private final InternalDriverContext context;
    private Queue<Node> queryPlan;
    private final DriverExecutionProfile executionProfile;
    private final GraphStatement<?> graphStatement;
    private final boolean isIdempotent;
    protected final CompletableFuture<AsyncGraphResultSet> result;
    private final Message message;
    private final String subProtocol;
    private final EventExecutor scheduler;
    private final AtomicInteger activeExecutionsCount;
    private final AtomicInteger startedSpeculativeExecutionsCount;
    private final SpeculativeExecutionPolicy speculativeExecutionPolicy;
    private final ScheduledFuture<?> timeoutFuture;
    private final List<ScheduledFuture<?>> scheduledExecutions;
    private final List<PerRequestCallback> inFlightCallbacks;
    private final RetryPolicy retryPolicy;
    private final RequestThrottler throttler;
    private volatile List<Map.Entry<Node, Throwable>> errors;

    public GraphRequestHandler(@NonNull GraphStatement<?> graphStatement, @NonNull DefaultSession dseSession, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix) {
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        Preconditions.checkArgument((graphStatement instanceof ScriptGraphStatement || graphStatement instanceof FluentGraphStatement || graphStatement instanceof BatchGraphStatement || graphStatement instanceof BytecodeGraphStatement ? 1 : 0) != 0, (Object)("Unknown graph statement type: " + graphStatement.getClass()));
        LOG.trace("[{}] Creating new Graph request handler for request {}", (Object)this.logPrefix, graphStatement);
        this.graphStatement = graphStatement;
        this.session = dseSession;
        this.context = context;
        this.executionProfile = GraphConversions.resolveExecutionProfile(this.graphStatement, (DriverContext)this.context);
        Boolean statementIsIdempotent = graphStatement.isIdempotent();
        this.isIdempotent = statementIsIdempotent == null ? this.executionProfile.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE) : statementIsIdempotent.booleanValue();
        this.result = new CompletableFuture();
        this.result.exceptionally(t -> {
            try {
                if (t instanceof CancellationException) {
                    this.cancelScheduledTasks();
                }
            }
            catch (Throwable t2) {
                Loggers.warnWithException((Logger)LOG, (String)"[{}] Uncaught exception", (Object[])new Object[]{this.logPrefix, t2});
            }
            return null;
        });
        this.scheduler = context.getNettyOptions().ioEventLoopGroup().next();
        Duration timeout = graphStatement.getTimeout();
        if (timeout == null) {
            timeout = this.executionProfile.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, null);
        }
        this.timeoutFuture = this.scheduleTimeout(timeout);
        this.retryPolicy = context.getRetryPolicy(this.executionProfile.getName());
        this.speculativeExecutionPolicy = context.getSpeculativeExecutionPolicy(this.executionProfile.getName());
        this.activeExecutionsCount = new AtomicInteger(1);
        this.startedSpeculativeExecutionsCount = new AtomicInteger(0);
        this.scheduledExecutions = this.isIdempotent ? new CopyOnWriteArrayList() : null;
        this.inFlightCallbacks = new CopyOnWriteArrayList<PerRequestCallback>();
        this.subProtocol = GraphConversions.inferSubProtocol(this.graphStatement, this.executionProfile, this.session);
        this.message = GraphConversions.createMessageFromGraphStatement(this.graphStatement, this.subProtocol, this.executionProfile, context);
        this.throttler = context.getRequestThrottler();
        this.throttler.register((Throttled)this);
    }

    public void onThrottleReady(boolean wasDelayed) {
        if (wasDelayed) {
            this.session.getMetricUpdater().updateTimer((Object)DefaultSessionMetric.THROTTLING_DELAY, this.executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        this.queryPlan = this.context.getLoadBalancingPolicyWrapper().newQueryPlan(this.graphStatement, this.executionProfile.getName(), (Session)this.session);
        this.sendRequest(null, 0, 0, true);
    }

    public CompletionStage<AsyncGraphResultSet> handle() {
        return this.result;
    }

    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        this.session.getMetricUpdater().incrementCounter((Object)DefaultSessionMetric.THROTTLING_ERRORS, this.executionProfile.getName());
        this.setFinalError((Throwable)error, null);
    }

    private ScheduledFuture<?> scheduleTimeout(Duration timeout) {
        if (timeout != null && timeout.toNanos() > 0L) {
            return this.scheduler.schedule(() -> this.setFinalError((Throwable)new DriverTimeoutException("Query timed out after " + timeout), null), timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        return null;
    }

    private void sendRequest(Node node, int currentExecutionIndex, int retryCount, boolean scheduleNextExecution) {
        if (this.result.isDone()) {
            return;
        }
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            while (!this.result.isDone() && (node = this.queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            }
        }
        if (channel == null) {
            if (!this.result.isDone() && this.activeExecutionsCount.decrementAndGet() == 0) {
                this.setFinalError((Throwable)AllNodesFailedException.fromErrors(this.errors), null);
            }
        } else {
            PerRequestCallback perRequestCallback = new PerRequestCallback(node, channel, currentExecutionIndex, retryCount, scheduleNextExecution, this.logPrefix);
            channel.write(this.message, this.graphStatement.isTracing(), GraphConversions.createCustomPayload(this.graphStatement, this.subProtocol, this.executionProfile, this.context), (ResponseCallback)perRequestCallback).addListener((GenericFutureListener)perRequestCallback);
        }
    }

    private void cancelScheduledTasks() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        if (this.scheduledExecutions != null) {
            for (ScheduledFuture scheduledFuture : this.scheduledExecutions) {
                scheduledFuture.cancel(false);
            }
        }
        for (PerRequestCallback perRequestCallback : this.inFlightCallbacks) {
            perRequestCallback.cancel();
        }
    }

    private void setFinalError(Throwable error, Node node) {
        if (this.result.completeExceptionally(error)) {
            this.cancelScheduledTasks();
            long latencyNanos = System.nanoTime() - this.startTimeNanos;
            this.context.getRequestTracker().onError(this.graphStatement, error, latencyNanos, this.executionProfile, node, this.logPrefix);
            if (error instanceof DriverTimeoutException) {
                this.throttler.signalTimeout((Throttled)this);
                this.session.getMetricUpdater().incrementCounter((Object)DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, this.executionProfile.getName());
            } else if (!(error instanceof RequestThrottlingException)) {
                this.throttler.signalError((Throttled)this, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Node node, Throwable error) {
        List<Map.Entry<Node, Throwable>> errorsSnapshot = this.errors;
        if (errorsSnapshot == null) {
            GraphRequestHandler graphRequestHandler = this;
            synchronized (graphRequestHandler) {
                errorsSnapshot = this.errors;
                if (errorsSnapshot == null) {
                    this.errors = errorsSnapshot = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
                }
            }
        }
        errorsSnapshot.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error));
    }

    private class PerRequestCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final long start = System.nanoTime();
        private final Node node;
        private final DriverChannel channel;
        private final int execution;
        private final int retryCount;
        private final boolean scheduleNextExecution;
        private final String logPrefix;

        PerRequestCallback(Node node, DriverChannel channel, int execution, int retryCount, boolean scheduleNextExecution, String logPrefix) {
            this.node = node;
            this.channel = channel;
            this.execution = execution;
            this.retryCount = retryCount;
            this.scheduleNextExecution = scheduleNextExecution;
            this.logPrefix = logPrefix + "|" + execution;
        }

        public void onFailure(Throwable error) {
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            LOG.trace("[{}] Request failure, processing: {}", (Object)this.logPrefix, (Object)error.toString());
            RetryDecision decision = !GraphRequestHandler.this.isIdempotent || error instanceof FrameTooLongException ? RetryDecision.RETHROW : GraphRequestHandler.this.retryPolicy.onRequestAborted((Request)GraphRequestHandler.this.graphStatement, error, this.retryCount);
            this.processRetryDecision(decision, error);
            this.updateErrorMetrics(((DefaultNode)this.node).getMetricUpdater(), decision, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED);
        }

        public void operationComplete(Future<Void> voidFuture) {
            if (!voidFuture.isSuccess()) {
                Throwable error = voidFuture.cause();
                if (error instanceof EncoderException && error.getCause() instanceof FrameTooLongException) {
                    GraphRequestHandler.this.setFinalError(error.getCause(), this.node);
                } else {
                    LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", new Object[]{this.logPrefix, this.channel, error});
                    GraphRequestHandler.this.recordError(this.node, error);
                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter((Object)DefaultNodeMetric.UNSENT_REQUESTS, GraphRequestHandler.this.executionProfile.getName());
                    GraphRequestHandler.this.sendRequest(null, this.execution, this.retryCount, this.scheduleNextExecution);
                }
            } else {
                LOG.trace("[{}] Request sent on {}", (Object)this.logPrefix, (Object)this.channel);
                if (GraphRequestHandler.this.result.isDone()) {
                    this.cancel();
                } else {
                    GraphRequestHandler.this.inFlightCallbacks.add(this);
                    if (this.scheduleNextExecution && GraphRequestHandler.this.isIdempotent) {
                        int nextExecution = this.execution + 1;
                        long nextDelay = GraphRequestHandler.this.speculativeExecutionPolicy.nextExecution(this.node, null, (Request)GraphRequestHandler.this.graphStatement, nextExecution);
                        if (nextDelay >= 0L) {
                            LOG.trace("[{}] Scheduling speculative execution {} in {} ms", new Object[]{this.logPrefix, nextExecution, nextDelay});
                            GraphRequestHandler.this.scheduledExecutions.add(GraphRequestHandler.this.scheduler.schedule(() -> {
                                if (!GraphRequestHandler.this.result.isDone()) {
                                    LOG.trace("[{}] Starting speculative execution {}", (Object)GraphRequestHandler.this.logPrefix, (Object)nextExecution);
                                    GraphRequestHandler.this.activeExecutionsCount.incrementAndGet();
                                    GraphRequestHandler.this.startedSpeculativeExecutionsCount.incrementAndGet();
                                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter((Object)DefaultNodeMetric.SPECULATIVE_EXECUTIONS, GraphRequestHandler.this.executionProfile.getName());
                                    GraphRequestHandler.this.sendRequest(null, nextExecution, 0, true);
                                }
                            }, nextDelay, TimeUnit.MILLISECONDS));
                        } else {
                            LOG.trace("[{}] Speculative execution policy returned {}, no next execution", (Object)this.logPrefix, (Object)nextDelay);
                        }
                    }
                }
            }
        }

        public void onResponse(Frame responseFrame) {
            ((DefaultNode)this.node).getMetricUpdater().updateTimer((Object)DefaultNodeMetric.CQL_MESSAGES, GraphRequestHandler.this.executionProfile.getName(), System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            try {
                Message responseMessage = responseFrame.message;
                if (responseMessage instanceof Result) {
                    LOG.trace("[{}] Got result, completing", (Object)this.logPrefix);
                    this.setFinalResult((Result)responseMessage, responseFrame, this);
                } else if (responseMessage instanceof Error) {
                    LOG.trace("[{}] Got error response, processing", (Object)this.logPrefix);
                    this.processErrorResponse((Error)responseMessage);
                } else {
                    GraphRequestHandler.this.setFinalError(new IllegalStateException("Unexpected response " + responseMessage), this.node);
                }
            }
            catch (Throwable t) {
                GraphRequestHandler.this.setFinalError(t, this.node);
            }
        }

        private void setFinalResult(Result resultMessage, Frame responseFrame, PerRequestCallback callback) {
            try {
                GraphExecutionInfo executionInfo = this.buildExecutionInfo(callback, responseFrame);
                ArrayDeque<GraphNode> graphNodes = new ArrayDeque<GraphNode>();
                for (List row : ((Rows)resultMessage).getData()) {
                    graphNodes.offer(GraphSONUtils.createGraphNode(row, GraphRequestHandler.this.subProtocol));
                }
                DefaultAsyncGraphResultSet resultSet = new DefaultAsyncGraphResultSet(executionInfo, graphNodes);
                if (GraphRequestHandler.this.result.complete(resultSet)) {
                    GraphRequestHandler.this.cancelScheduledTasks();
                    GraphRequestHandler.this.throttler.signalSuccess((Throttled)GraphRequestHandler.this);
                    long latencyNanos = System.nanoTime() - GraphRequestHandler.this.startTimeNanos;
                    GraphRequestHandler.this.context.getRequestTracker().onSuccess((Request)GraphRequestHandler.this.graphStatement, latencyNanos, GraphRequestHandler.this.executionProfile, callback.node, this.logPrefix);
                    GraphRequestHandler.this.session.getMetricUpdater().updateTimer((Object)DefaultSessionMetric.CQL_REQUESTS, GraphRequestHandler.this.executionProfile.getName(), latencyNanos, TimeUnit.NANOSECONDS);
                }
            }
            catch (Throwable error) {
                GraphRequestHandler.this.setFinalError(error, callback.node);
            }
        }

        private GraphExecutionInfo buildExecutionInfo(PerRequestCallback callback, Frame responseFrame) {
            return new DefaultGraphExecutionInfo(GraphRequestHandler.this.graphStatement, callback.node, GraphRequestHandler.this.startedSpeculativeExecutionsCount.get(), callback.execution, GraphRequestHandler.this.errors, responseFrame);
        }

        private void processErrorResponse(Error errorMessage) {
            CoordinatorException error = GraphConversions.toThrowable((Node)this.node, (Error)errorMessage, (InternalDriverContext)GraphRequestHandler.this.context);
            NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (error instanceof BootstrappingException) {
                LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)this.logPrefix, (Object)this.node);
                GraphRequestHandler.this.recordError(this.node, (Throwable)error);
                GraphRequestHandler.this.sendRequest(null, this.execution, this.retryCount, false);
            } else if (error instanceof QueryValidationException || error instanceof FunctionFailureException || error instanceof ProtocolError) {
                LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)this.logPrefix);
                metricUpdater.incrementCounter((Object)DefaultNodeMetric.OTHER_ERRORS, GraphRequestHandler.this.executionProfile.getName());
                GraphRequestHandler.this.setFinalError((Throwable)error, this.node);
            } else {
                RetryDecision decision;
                if (error instanceof ReadTimeoutException) {
                    ReadTimeoutException readTimeout = (ReadTimeoutException)error;
                    decision = GraphRequestHandler.this.retryPolicy.onReadTimeout((Request)GraphRequestHandler.this.graphStatement, readTimeout.getConsistencyLevel(), readTimeout.getBlockFor(), readTimeout.getReceived(), readTimeout.wasDataPresent(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT);
                } else if (error instanceof WriteTimeoutException) {
                    WriteTimeoutException writeTimeout = (WriteTimeoutException)error;
                    decision = GraphRequestHandler.this.isIdempotent ? GraphRequestHandler.this.retryPolicy.onWriteTimeout((Request)GraphRequestHandler.this.graphStatement, writeTimeout.getConsistencyLevel(), writeTimeout.getWriteType(), writeTimeout.getBlockFor(), writeTimeout.getReceived(), this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT);
                } else if (error instanceof UnavailableException) {
                    UnavailableException unavailable = (UnavailableException)error;
                    decision = GraphRequestHandler.this.retryPolicy.onUnavailable((Request)GraphRequestHandler.this.graphStatement, unavailable.getConsistencyLevel(), unavailable.getRequired(), unavailable.getAlive(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE);
                } else {
                    decision = GraphRequestHandler.this.isIdempotent ? GraphRequestHandler.this.retryPolicy.onErrorResponse((Request)GraphRequestHandler.this.graphStatement, error, this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR);
                }
                this.processRetryDecision(decision, (Throwable)error);
            }
        }

        private void processRetryDecision(RetryDecision decision, Throwable error) {
            LOG.trace("[{}] Processing retry decision {}", (Object)this.logPrefix, (Object)decision);
            switch (decision) {
                case RETRY_SAME: {
                    GraphRequestHandler.this.recordError(this.node, error);
                    GraphRequestHandler.this.sendRequest(this.node, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETRY_NEXT: {
                    GraphRequestHandler.this.recordError(this.node, error);
                    GraphRequestHandler.this.sendRequest(null, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETHROW: {
                    GraphRequestHandler.this.setFinalError(error, this.node);
                    break;
                }
                case IGNORE: {
                    this.setFinalResult((Result)com.datastax.oss.protocol.internal.response.result.Void.INSTANCE, null, this);
                }
            }
        }

        private void updateErrorMetrics(NodeMetricUpdater metricUpdater, RetryDecision decision, DefaultNodeMetric error, DefaultNodeMetric retriesOnError, DefaultNodeMetric ignoresOnError) {
            metricUpdater.incrementCounter((Object)error, GraphRequestHandler.this.executionProfile.getName());
            switch (decision) {
                case RETRY_SAME: 
                case RETRY_NEXT: {
                    metricUpdater.incrementCounter((Object)DefaultNodeMetric.RETRIES, GraphRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter((Object)retriesOnError, GraphRequestHandler.this.executionProfile.getName());
                    break;
                }
                case IGNORE: {
                    metricUpdater.incrementCounter((Object)DefaultNodeMetric.IGNORES, GraphRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter((Object)ignoresOnError, GraphRequestHandler.this.executionProfile.getName());
                    break;
                }
            }
        }

        void cancel() {
            try {
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.cancel((ResponseCallback)this);
                }
            }
            catch (Throwable t) {
                Loggers.warnWithException((Logger)LOG, (String)"[{}] Error cancelling", (Object[])new Object[]{this.logPrefix, t});
            }
        }

        public String toString() {
            return this.logPrefix;
        }
    }
}

