/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphResultSets;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class GraphRequestSyncProcessor
implements RequestProcessor<GraphStatement<?>, GraphResultSet> {
    private final GraphRequestAsyncProcessor asyncProcessor;

    public GraphRequestSyncProcessor(GraphRequestAsyncProcessor asyncProcessor) {
        this.asyncProcessor = asyncProcessor;
    }

    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof GraphStatement && resultType.equals(GraphStatement.SYNC);
    }

    public GraphResultSet process(GraphStatement<?> request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        BlockingOperation.checkNotDriverThread();
        AsyncGraphResultSet firstPage = (AsyncGraphResultSet)CompletableFutures.getUninterruptibly(this.asyncProcessor.process(request, session, context, sessionLogPrefix));
        return GraphResultSets.toSync(firstPage);
    }

    public GraphResultSet newFailure(RuntimeException error) {
        throw error;
    }
}

