/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.DseSession;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphSON1SerdeTP;
import com.datastax.dse.driver.internal.core.graph.GraphSON2SerdeTP;
import com.datastax.dse.driver.internal.core.graph.GraphSON3SerdeTP;
import com.datastax.dse.driver.internal.core.graph.LegacyGraphNode;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.oss.driver.shaded.guava.common.base.Suppliers;
import com.datastax.oss.driver.shaded.guava.common.base.Throwables;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheLoader;
import com.datastax.oss.driver.shaded.guava.common.cache.LoadingCache;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONXModuleV2d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONXModuleV3d0;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV2d0;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0;
import org.apache.tinkerpop.shaded.jackson.core.Version;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;

class GraphSONUtils {
    public static final String GRAPHSON_1_0 = "graphson-1.0";
    public static final String GRAPHSON_2_0 = "graphson-2.0";
    public static final String GRAPHSON_3_0 = "graphson-3.0";
    private static final LoadingCache<String, ObjectMapper> OBJECT_MAPPERS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ObjectMapper>(){

        public ObjectMapper load(@NonNull String graphSubProtocol) throws Exception {
            switch (graphSubProtocol) {
                case "graphson-1.0": {
                    com.datastax.oss.driver.api.core.Version driverVersion = DseSession.DSE_DRIVER_COORDINATES.getVersion();
                    Version driverJacksonVersion = new Version(driverVersion.getMajor(), driverVersion.getMinor(), driverVersion.getPatch(), driverVersion.getPreReleaseLabels() != null && driverVersion.getPreReleaseLabels().contains("SNAPSHOT") ? "SNAPSHOT" : null, "com.datastax.dse", "dse-java-driver-core");
                    ObjectMapper mapper = GraphSONMapper.build().version(GraphSONVersion.V1_0).create().createMapper();
                    mapper.registerModule((Module)new GraphSON1SerdeTP.GraphSON1DefaultModule("graph-graphson1default", driverJacksonVersion));
                    mapper.registerModule((Module)new GraphSON1SerdeTP.GraphSON1JavaTimeModule("graph-graphson1javatime", driverJacksonVersion));
                    return mapper;
                }
                case "graphson-2.0": {
                    return GraphSONMapper.build().version(GraphSONVersion.V2_0).addCustomModule((SimpleModule)GraphSONXModuleV2d0.build().create(false)).addRegistry((IoRegistry)TinkerIoRegistryV2d0.instance()).addCustomModule((SimpleModule)new GraphSON2SerdeTP.DseGraphModule()).addCustomModule((SimpleModule)new GraphSON2SerdeTP.DriverObjectsModule()).create().createMapper();
                }
                case "graphson-3.0": {
                    return GraphSONMapper.build().version(GraphSONVersion.V3_0).addCustomModule((SimpleModule)GraphSONXModuleV3d0.build().create(false)).addRegistry((IoRegistry)TinkerIoRegistryV3d0.instance()).addCustomModule((SimpleModule)new GraphSON3SerdeTP.DseGraphModule()).addCustomModule((SimpleModule)new GraphSON3SerdeTP.DriverObjectsModule()).create().createMapper();
                }
            }
            throw new IllegalStateException(String.format("Unknown graph sub-protocol: {%s}", graphSubProtocol));
        }
    });
    static final Supplier<GraphSONReader> GRAPHSON1_READER = Suppliers.memoize(() -> GraphSONReader.build().mapper((Mapper)GraphSONMapper.build().version(GraphSONVersion.V1_0).create()).create());

    GraphSONUtils() {
    }

    static ByteBuffer serializeToByteBuffer(Object object, String graphSubProtocol) throws IOException {
        return ByteBuffer.wrap(GraphSONUtils.serializeToBytes(object, graphSubProtocol));
    }

    static byte[] serializeToBytes(Object object, String graphSubProtocol) throws IOException {
        try {
            return ((ObjectMapper)OBJECT_MAPPERS.get((Object)graphSubProtocol)).writeValueAsBytes(object);
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static GraphNode createGraphNode(List<ByteBuffer> data, String graphSubProtocol) throws IOException {
        try {
            ObjectMapper mapper = (ObjectMapper)OBJECT_MAPPERS.get((Object)graphSubProtocol);
            switch (graphSubProtocol) {
                case "graphson-1.0": {
                    return new LegacyGraphNode(mapper.readTree(Bytes.getArray((ByteBuffer)data.get(0))), mapper);
                }
                case "graphson-2.0": 
                case "graphson-3.0": {
                    return new ObjectGraphNode(mapper.readValue(Bytes.getArray((ByteBuffer)data.get(0)), Object.class));
                }
            }
            throw new AssertionError((Object)String.format("Unknown graph sub-protocol: {%s}", graphSubProtocol));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

