/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.context.DseDriverContext;
import com.datastax.dse.driver.internal.core.insights.PackageUtil;
import com.datastax.dse.driver.internal.core.insights.schema.LoadBalancingInfo;
import com.datastax.dse.driver.internal.core.insights.schema.SpecificExecutionProfile;
import com.datastax.dse.driver.internal.core.insights.schema.SpeculativeExecutionInfo;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class ExecutionProfilesInfoFinder {
    ExecutionProfilesInfoFinder() {
    }

    Map<String, SpecificExecutionProfile> getExecutionProfilesInfo(DseDriverContext driverContext) {
        SpecificExecutionProfile defaultProfile = this.mapToSpecificProfile(driverContext.getConfig().getDefaultProfile());
        return driverContext.getConfig().getProfiles().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (this.isNotDefaultProfile((Map.Entry<String, ? extends DriverExecutionProfile>)e)) {
                SpecificExecutionProfile specificExecutionProfile = this.mapToSpecificProfile((DriverExecutionProfile)e.getValue());
                return this.retainOnlyDifferentFieldsFromSpecificProfile(defaultProfile, specificExecutionProfile);
            }
            return defaultProfile;
        }));
    }

    private boolean isNotDefaultProfile(Map.Entry<String, ? extends DriverExecutionProfile> e) {
        return !e.getKey().equals("default");
    }

    private SpecificExecutionProfile retainOnlyDifferentFieldsFromSpecificProfile(SpecificExecutionProfile defaultProfile, SpecificExecutionProfile specificExecutionProfile) {
        Integer readTimeout = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getReadTimeout);
        LoadBalancingInfo loadBalancingInfo = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getLoadBalancing);
        SpeculativeExecutionInfo speculativeExecutionInfo = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getSpeculativeExecution);
        String consistency = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getConsistency);
        String serialConsistency = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getSerialConsistency);
        Map graphOptions = this.getIfDifferentOrReturnNull(defaultProfile, specificExecutionProfile, SpecificExecutionProfile::getGraphOptions);
        return new SpecificExecutionProfile(readTimeout, loadBalancingInfo, speculativeExecutionInfo, consistency, serialConsistency, graphOptions);
    }

    private <T> T getIfDifferentOrReturnNull(SpecificExecutionProfile defaultProfile, SpecificExecutionProfile profile, Function<SpecificExecutionProfile, T> valueExtractor) {
        T specificProfileValue;
        T defaultProfileValue = valueExtractor.apply(defaultProfile);
        if (defaultProfileValue.equals(specificProfileValue = valueExtractor.apply(profile))) {
            return null;
        }
        return specificProfileValue;
    }

    private SpecificExecutionProfile mapToSpecificProfile(DriverExecutionProfile driverExecutionProfile) {
        return new SpecificExecutionProfile((int)driverExecutionProfile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT).toMillis(), this.getLoadBalancingInfo(driverExecutionProfile), this.getSpeculativeExecutionInfo(driverExecutionProfile), driverExecutionProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY), driverExecutionProfile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY), this.getGraphOptions(driverExecutionProfile));
    }

    private SpeculativeExecutionInfo getSpeculativeExecutionInfo(DriverExecutionProfile driverExecutionProfile) {
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        this.putIfExists(options, "maxSpeculativeExecutions", DefaultDriverOption.SPECULATIVE_EXECUTION_MAX, driverExecutionProfile);
        this.putIfExists(options, "delay", DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY, driverExecutionProfile);
        PackageUtil.ClassSettingDetails speculativeExecutionDetails = PackageUtil.getSpeculativeExecutionDetails(driverExecutionProfile.getString((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS));
        return new SpeculativeExecutionInfo(speculativeExecutionDetails.getClassName(), options, speculativeExecutionDetails.getFullPackage());
    }

    private void putIfExists(Map<String, Object> options, String key, DefaultDriverOption option, DriverExecutionProfile executionProfile) {
        if (executionProfile.isDefined((DriverOption)option)) {
            options.put(key, executionProfile.getInt((DriverOption)option));
        }
    }

    private LoadBalancingInfo getLoadBalancingInfo(DriverExecutionProfile driverExecutionProfile) {
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("localDataCenter", driverExecutionProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER));
        options.put("filterFunction", driverExecutionProfile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_FILTER_CLASS));
        PackageUtil.ClassSettingDetails loadBalancingDetails = PackageUtil.getLoadBalancingDetails(driverExecutionProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS));
        return new LoadBalancingInfo(loadBalancingDetails.getClassName(), options, loadBalancingDetails.getFullPackage());
    }

    private Map<String, Object> getGraphOptions(DriverExecutionProfile driverExecutionProfile) {
        HashMap<String, Object> graphOptionsMap = new HashMap<String, Object>();
        String graphTraversalSource = driverExecutionProfile.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
        if (graphTraversalSource != null) {
            graphOptionsMap.put("source", graphTraversalSource);
        }
        return graphOptionsMap;
    }
}

