/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import java.util.Collection;

class InsightsSupportVerifier {
    private static final Version minDse6Version = Version.parse((String)"6.0.5");
    private static final Version minDse51Version = Version.parse((String)"5.1.13");
    private static final Version dse600Version = Version.parse((String)"6.0.0");

    InsightsSupportVerifier() {
    }

    static boolean supportsInsights(Collection<Node> nodes) {
        assert (minDse6Version != null);
        assert (dse600Version != null);
        assert (minDse51Version != null);
        if (nodes.isEmpty()) {
            return false;
        }
        for (Node node : nodes) {
            Object version = node.getExtras().get("DSE_VERSION");
            if (version == null) {
                return false;
            }
            Version dseVersion = (Version)version;
            if (dseVersion.compareTo(minDse6Version) >= 0 || dseVersion.compareTo(dse600Version) < 0 && dseVersion.compareTo(minDse51Version) >= 0) continue;
            return false;
        }
        return true;
    }
}

