/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.PackageUtil;
import com.datastax.dse.driver.internal.core.insights.schema.ReconnectionPolicyInfo;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.internal.core.connection.ConstantReconnectionPolicy;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import java.util.HashMap;

class ReconnectionPolicyInfoFinder {
    ReconnectionPolicyInfoFinder() {
    }

    ReconnectionPolicyInfo getReconnectionPolicyInfo(ReconnectionPolicy reconnectionPolicy, DriverExecutionProfile executionProfile) {
        Class<?> reconnectionPolicyClass = reconnectionPolicy.getClass();
        String type = reconnectionPolicyClass.getSimpleName();
        String namespace = PackageUtil.getNamespace(reconnectionPolicyClass);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (reconnectionPolicy instanceof ConstantReconnectionPolicy) {
            options.put("delayMs", executionProfile.getDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY).toMillis());
        } else if (reconnectionPolicy instanceof ExponentialReconnectionPolicy) {
            ExponentialReconnectionPolicy exponentialReconnectionPolicy = (ExponentialReconnectionPolicy)reconnectionPolicy;
            options.put("maxDelayMs", exponentialReconnectionPolicy.getMaxDelayMs());
            options.put("baseDelayMs", exponentialReconnectionPolicy.getBaseDelayMs());
            options.put("maxAttempts", exponentialReconnectionPolicy.getMaxAttempts());
        }
        return new ReconnectionPolicyInfo(type, options, namespace);
    }
}

