/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.DefaultTopologyMonitor;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DseTopologyMonitor
extends DefaultTopologyMonitor {
    public DseTopologyMonitor(InternalDriverContext context) {
        super(context);
    }

    @NonNull
    protected DefaultNodeInfo.Builder nodeInfoBuilder(@NonNull AdminRow row, @Nullable InetSocketAddress broadcastRpcAddress, @NonNull EndPoint localEndPoint) {
        Set modernWorkloads;
        String legacyWorkload;
        DefaultNodeInfo.Builder builder = super.nodeInfoBuilder(row, broadcastRpcAddress, localEndPoint);
        String rawVersion = row.getString("dse_version");
        if (rawVersion != null) {
            builder.withExtra("DSE_VERSION", (Object)Version.parse((String)rawVersion));
        }
        ImmutableSet.Builder workloadsBuilder = ImmutableSet.builder();
        Boolean legacyGraph = row.getBoolean("graph");
        if (legacyGraph != null && legacyGraph.booleanValue()) {
            workloadsBuilder.add((Object)"Graph");
        }
        if ((legacyWorkload = row.getString("workload")) != null) {
            workloadsBuilder.add((Object)legacyWorkload);
        }
        if ((modernWorkloads = row.getSetOfString("workloads")) != null) {
            workloadsBuilder.addAll((Iterable)modernWorkloads);
        }
        builder.withExtra("DSE_WORKLOADS", (Object)workloadsBuilder.build());
        builder.withExtra("SERVER_ID", (Object)row.getString("server_id")).withExtra("NATIVE_TRANSPORT_PORT", (Object)row.getInteger("native_transport_port")).withExtra("NATIVE_TRANSPORT_PORT_SSL", (Object)row.getInteger("native_transport_port_ssl")).withExtra("STORAGE_PORT", (Object)row.getInteger("storage_port")).withExtra("STORAGE_PORT_SSL", (Object)row.getInteger("storage_port_ssl")).withExtra("JMX_PORT", (Object)row.getInteger("jmx_port"));
        return builder;
    }
}

