/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseTableMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDseTableMetadata
implements DseTableMetadata {
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final CqlIdentifier name;
    @Nullable
    private final UUID id;
    private final boolean compactStorage;
    private final boolean virtual;
    @NonNull
    private final List<ColumnMetadata> partitionKey;
    @NonNull
    private final Map<ColumnMetadata, ClusteringOrder> clusteringColumns;
    @NonNull
    private final Map<CqlIdentifier, ColumnMetadata> columns;
    @NonNull
    private final Map<CqlIdentifier, Object> options;
    @NonNull
    private final Map<CqlIdentifier, IndexMetadata> indexes;

    public DefaultDseTableMetadata(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name, @Nullable UUID id, boolean compactStorage, boolean virtual, @NonNull List<ColumnMetadata> partitionKey, @NonNull Map<ColumnMetadata, ClusteringOrder> clusteringColumns, @NonNull Map<CqlIdentifier, ColumnMetadata> columns, @NonNull Map<CqlIdentifier, Object> options, @NonNull Map<CqlIdentifier, IndexMetadata> indexes) {
        this.keyspace = keyspace;
        this.name = name;
        this.id = id;
        this.compactStorage = compactStorage;
        this.virtual = virtual;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
        this.indexes = indexes;
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @NonNull
    public Optional<UUID> getId() {
        return Optional.ofNullable(this.id);
    }

    public boolean isCompactStorage() {
        return this.compactStorage;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    @NonNull
    public List<ColumnMetadata> getPartitionKey() {
        return this.partitionKey;
    }

    @NonNull
    public Map<ColumnMetadata, ClusteringOrder> getClusteringColumns() {
        return this.clusteringColumns;
    }

    @NonNull
    public Map<CqlIdentifier, ColumnMetadata> getColumns() {
        return this.columns;
    }

    @NonNull
    public Map<CqlIdentifier, Object> getOptions() {
        return this.options;
    }

    @NonNull
    public Map<CqlIdentifier, IndexMetadata> getIndexes() {
        return this.indexes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DseTableMetadata) {
            DseTableMetadata that = (DseTableMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.name, that.getName()) && Objects.equals(Optional.ofNullable(this.id), that.getId()) && this.compactStorage == that.isCompactStorage() && this.virtual == that.isVirtual() && Objects.equals(this.partitionKey, that.getPartitionKey()) && Objects.equals(this.clusteringColumns, that.getClusteringColumns()) && Objects.equals(this.columns, that.getColumns()) && Objects.equals(this.indexes, that.getIndexes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name, this.id, this.compactStorage, this.virtual, this.partitionKey, this.clusteringColumns, this.columns, this.indexes);
    }
}

