/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema.parsing;

import com.datastax.dse.driver.api.core.metadata.schema.DseIndexMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseTableMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseColumnMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseIndexMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseTableMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexKind;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameCompositeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RawColumn;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.TableParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseTableParser
extends RelationParser {
    private static final Logger LOG = LoggerFactory.getLogger(TableParser.class);

    public DseTableParser(SchemaRows rows, InternalDriverContext context) {
        super(rows, context);
    }

    public DseTableMetadata parseTable(AdminRow tableRow, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes) {
        Map<CqlIdentifier, Object> options;
        DseIndexMetadata index;
        boolean isCompactStorage;
        CqlIdentifier tableId = CqlIdentifier.fromInternal((String)tableRow.getString(tableRow.contains("table_name") ? "table_name" : "columnfamily_name"));
        UUID uuid = tableRow.contains("id") ? tableRow.getUuid("id") : tableRow.getUuid("cf_id");
        List rawColumns = RawColumn.toRawColumns((Collection)((Multimap)this.rows.columns().getOrDefault(keyspaceId, ImmutableMultimap.of())).get((Object)tableId), (CqlIdentifier)keyspaceId, userTypes);
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing TABLE refresh for {}.{} but found no matching rows, skipping", new Object[]{this.logPrefix, keyspaceId, tableId});
            return null;
        }
        if (tableRow.contains("flags")) {
            boolean isStaticCompact;
            Set flags = tableRow.getSetOfString("flags");
            boolean isDense = flags.contains("dense");
            boolean isSuper = flags.contains("super");
            boolean isCompound = flags.contains("compound");
            isCompactStorage = isSuper || isDense || !isCompound;
            boolean bl = isStaticCompact = !isSuper && !isDense && !isCompound;
            if (isStaticCompact) {
                RawColumn.pruneStaticCompactTableColumns((List)rawColumns);
            } else if (isDense) {
                RawColumn.pruneDenseTableColumnsV3((List)rawColumns);
            }
        } else {
            boolean isDense = tableRow.getBoolean("is_dense");
            if (isDense) {
                RawColumn.pruneDenseTableColumnsV2((List)rawColumns);
            }
            DataTypeClassNameCompositeParser.ParseResult comparator = new DataTypeClassNameCompositeParser().parseWithComposite(tableRow.getString("comparator"), keyspaceId, userTypes, this.context);
            isCompactStorage = isDense || !comparator.isComposite;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder clusteringColumnsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder indexesBuilder = ImmutableMap.builder();
        for (RawColumn raw : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw.dataType, userTypes, this.context);
            DefaultDseColumnMetadata column = new DefaultDseColumnMetadata(keyspaceId, tableId, raw.name, dataType, raw.kind.equals("static"));
            switch (raw.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add((Object)column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put((Object)column, (Object)(raw.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                    break;
                }
            }
            allColumnsBuilder.put((Object)column.getName(), (Object)column);
            index = this.buildLegacyIndex(raw, column);
            if (index == null) continue;
            indexesBuilder.put((Object)index.getName(), (Object)index);
        }
        try {
            options = this.parseOptions(tableRow);
        }
        catch (Exception e) {
            Loggers.warnWithException((Logger)LOG, (String)"[{}] Error while parsing options for {}.{}, getOptions() will be empty", (Object[])new Object[]{this.logPrefix, keyspaceId, tableId, e});
            options = Collections.emptyMap();
        }
        Collection indexRows = ((Multimap)this.rows.indexes().getOrDefault(keyspaceId, ImmutableMultimap.of())).get((Object)tableId);
        for (AdminRow indexRow : indexRows) {
            index = this.buildModernIndex(keyspaceId, tableId, indexRow);
            indexesBuilder.put((Object)index.getName(), (Object)index);
        }
        return new DefaultDseTableMetadata(keyspaceId, tableId, uuid, isCompactStorage, false, (List<ColumnMetadata>)partitionKeyBuilder.build(), (Map<ColumnMetadata, ClusteringOrder>)clusteringColumnsBuilder.build(), (Map<CqlIdentifier, ColumnMetadata>)allColumnsBuilder.build(), options, (Map<CqlIdentifier, IndexMetadata>)indexesBuilder.build());
    }

    DseTableMetadata parseVirtualTable(AdminRow tableRow, CqlIdentifier keyspaceId) {
        CqlIdentifier tableId = CqlIdentifier.fromInternal((String)tableRow.getString("table_name"));
        List rawColumns = RawColumn.toRawColumns((Collection)((Multimap)this.rows.virtualColumns().getOrDefault(keyspaceId, ImmutableMultimap.of())).get((Object)tableId), (CqlIdentifier)keyspaceId, Collections.emptyMap());
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing TABLE refresh for {}.{} but found no matching rows, skipping", new Object[]{this.logPrefix, keyspaceId, tableId});
            return null;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder clusteringColumnsBuilder = ImmutableMap.builder();
        for (RawColumn raw : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw.dataType, Collections.emptyMap(), this.context);
            DefaultDseColumnMetadata column = new DefaultDseColumnMetadata(keyspaceId, tableId, raw.name, dataType, raw.kind.equals("static"));
            switch (raw.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add((Object)column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put((Object)column, (Object)(raw.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                    break;
                }
            }
            allColumnsBuilder.put((Object)column.getName(), (Object)column);
        }
        return new DefaultDseTableMetadata(keyspaceId, tableId, null, false, true, (List<ColumnMetadata>)partitionKeyBuilder.build(), (Map<ColumnMetadata, ClusteringOrder>)clusteringColumnsBuilder.build(), (Map<CqlIdentifier, ColumnMetadata>)allColumnsBuilder.build(), Collections.emptyMap(), Collections.emptyMap());
    }

    private DseIndexMetadata buildLegacyIndex(RawColumn raw, ColumnMetadata column) {
        if (raw.indexName == null) {
            return null;
        }
        return new DefaultDseIndexMetadata(column.getKeyspace(), column.getParent(), CqlIdentifier.fromInternal((String)raw.indexName), IndexKind.valueOf((String)raw.indexType), DseTableParser.buildLegacyIndexTarget(column, raw.indexOptions), raw.indexOptions);
    }

    private static String buildLegacyIndexTarget(ColumnMetadata column, Map<String, String> options) {
        String columnName = column.getName().asCql(true);
        DataType columnType = column.getType();
        if (options.containsKey("index_keys")) {
            return String.format("keys(%s)", columnName);
        }
        if (options.containsKey("index_keys_and_values")) {
            return String.format("entries(%s)", columnName);
        }
        if (columnType instanceof ListType && ((ListType)columnType).isFrozen() || columnType instanceof SetType && ((SetType)columnType).isFrozen() || columnType instanceof MapType && ((MapType)columnType).isFrozen()) {
            return String.format("full(%s)", columnName);
        }
        return columnName;
    }

    private DseIndexMetadata buildModernIndex(CqlIdentifier keyspaceId, CqlIdentifier tableId, AdminRow row) {
        CqlIdentifier name = CqlIdentifier.fromInternal((String)row.getString("index_name"));
        IndexKind kind = IndexKind.valueOf((String)row.getString("kind"));
        Map options = row.getMapOfStringToString("options");
        String target = (String)options.get("target");
        return new DefaultDseIndexMetadata(keyspaceId, tableId, name, kind, target, options);
    }
}

