/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra21SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra3SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra4SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.DefaultSchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueries;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseSchemaQueriesFactory
extends DefaultSchemaQueriesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaQueriesFactory.class);
    @NonNull
    private static final Version V5_0_0 = Version.parse((String)"5.0.0");
    @NonNull
    private static final Version V6_7_0 = Version.parse((String)"6.7.0");

    public DseSchemaQueriesFactory(InternalDriverContext context) {
        super(context);
    }

    protected SchemaQueries newInstance(Node node, DriverChannel channel, CompletableFuture<Metadata> refreshFuture) {
        Object versionObj = node.getExtras().get("DSE_VERSION");
        if (versionObj == null) {
            LOG.warn("[{}] DSE version missing for {}, deferring to C* version", (Object)this.logPrefix, (Object)node);
            return super.newInstance(node, channel, refreshFuture);
        }
        Version version = ((Version)versionObj).nextStable();
        DriverExecutionProfile config = this.context.getConfig().getDefaultProfile();
        LOG.debug("[{}] Sending schema queries to {} with DSE version {}", new Object[]{this.logPrefix, node, version});
        if (version.compareTo(V5_0_0) < 0) {
            return new Cassandra21SchemaQueries(channel, refreshFuture, config, this.logPrefix);
        }
        if (version.compareTo(V6_7_0) < 0) {
            return new Cassandra3SchemaQueries(channel, refreshFuture, config, this.logPrefix);
        }
        return new Cassandra4SchemaQueries(channel, refreshFuture, config, this.logPrefix);
    }
}

