/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.token;

import com.datastax.dse.driver.internal.core.metadata.token.EverywhereStrategy;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DseReplicationStrategyFactory
extends DefaultReplicationStrategyFactory {
    public DseReplicationStrategyFactory(InternalDriverContext context) {
        super(context);
    }

    public ReplicationStrategy newInstance(Map<String, String> replicationConfig) {
        String strategyClass = replicationConfig.get("class");
        Preconditions.checkNotNull((Object)strategyClass, (Object)("Missing replication strategy class in " + replicationConfig));
        switch (strategyClass) {
            case "org.apache.cassandra.locator.EverywhereStrategy": {
                return new EverywhereStrategy();
            }
        }
        return super.newInstance(replicationConfig);
    }
}

