/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.DseSessionMetric;
import com.datastax.dse.driver.internal.core.metrics.DseDropwizardSessionMetricUpdater;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseDropwizardMetricsFactory
extends DropwizardMetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricsFactory.class);
    private final SessionMetricUpdater dseSessionUpdater;
    private final String logPrefix;

    public DseDropwizardMetricsFactory(InternalDriverContext context) {
        super(context);
        this.logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set<SessionMetric> enabledSessionMetrics = this.parseSessionMetricPaths(config.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED));
        this.dseSessionUpdater = this.getMetrics().map(Metrics::getRegistry).map(registry -> new DseDropwizardSessionMetricUpdater(enabledSessionMetrics, (MetricRegistry)registry, context)).orElse((SessionMetricUpdater)NoopSessionMetricUpdater.INSTANCE);
    }

    public SessionMetricUpdater getSessionUpdater() {
        return this.dseSessionUpdater;
    }

    protected Set<SessionMetric> parseSessionMetricPaths(List<String> paths) {
        HashSet<DseSessionMetric> metrics = new HashSet<DseSessionMetric>();
        for (String path : paths) {
            try {
                metrics.add(DseSessionMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    metrics.add((DseSessionMetric)DefaultSessionMetric.fromPath((String)path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown session metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(metrics);
    }
}

