/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodec;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.esri.core.geometry.ogc.OGCPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PointCodec
extends GeometryCodec<Point> {
    private static final GenericType<Point> JAVA_TYPE = GenericType.of(Point.class);

    @NonNull
    public GenericType<Point> getJavaType() {
        return JAVA_TYPE;
    }

    @NonNull
    public DataType getCqlType() {
        return DseDataTypes.POINT;
    }

    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Point.class;
    }

    public boolean accepts(@NonNull Object value) {
        return value instanceof Point;
    }

    @Override
    @NonNull
    protected String toWellKnownText(@NonNull Point geometry) {
        return geometry.asWellKnownText();
    }

    @Override
    @NonNull
    protected ByteBuffer toWellKnownBinary(@NonNull Point geometry) {
        return geometry.asWellKnownBinary();
    }

    @Override
    @NonNull
    protected Point fromWellKnownText(@NonNull String source) {
        return new DefaultPoint(DefaultGeometry.fromOgcWellKnownText(source, OGCPoint.class));
    }

    @Override
    @NonNull
    protected Point fromWellKnownBinary(@NonNull ByteBuffer source) {
        return new DefaultPoint(DefaultGeometry.fromOgcWellKnownBinary(source, OGCPoint.class));
    }
}

