/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.time;

import com.datastax.dse.driver.api.core.data.time.DateRange;
import com.datastax.dse.driver.api.core.data.time.DateRangeBound;
import com.datastax.dse.driver.api.core.data.time.DateRangePrecision;
import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;

public class DateRangeCodec
implements TypeCodec<DateRange> {
    private static final GenericType<DateRange> JAVA_TYPE = GenericType.of(DateRange.class);
    private static final DataType CQL_TYPE = DseDataTypes.DATE_RANGE;
    private static final byte DATE_RANGE_TYPE_SINGLE_DATE = 0;
    private static final byte DATE_RANGE_TYPE_CLOSED_RANGE = 1;
    private static final byte DATE_RANGE_TYPE_OPEN_RANGE_HIGH = 2;
    private static final byte DATE_RANGE_TYPE_OPEN_RANGE_LOW = 3;
    private static final byte DATE_RANGE_TYPE_BOTH_OPEN_RANGE = 4;
    private static final byte DATE_RANGE_TYPE_SINGLE_DATE_OPEN = 5;

    @NonNull
    public GenericType<DateRange> getJavaType() {
        return JAVA_TYPE;
    }

    @NonNull
    public DataType getCqlType() {
        return CQL_TYPE;
    }

    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == DateRange.class;
    }

    @Nullable
    public ByteBuffer encode(@Nullable DateRange dateRange, @NonNull ProtocolVersion protocolVersion) {
        if (dateRange == null) {
            return null;
        }
        byte rangeType = DateRangeCodec.encodeType(dateRange);
        int bufferSize = 1;
        DateRangeBound lowerBound = dateRange.getLowerBound();
        Optional<DateRangeBound> maybeUpperBound = dateRange.getUpperBound();
        bufferSize += lowerBound.isUnbounded() ? 0 : 9;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize += maybeUpperBound.map(upperBound -> upperBound.isUnbounded() ? 0 : 9).orElse(0).intValue());
        buffer.put(rangeType);
        if (!lowerBound.isUnbounded()) {
            DateRangeCodec.put(buffer, lowerBound);
        }
        maybeUpperBound.ifPresent(upperBound -> {
            if (!upperBound.isUnbounded()) {
                DateRangeCodec.put(buffer, upperBound);
            }
        });
        return (ByteBuffer)buffer.flip();
    }

    private static byte encodeType(DateRange dateRange) {
        if (dateRange.isSingleBounded()) {
            return dateRange.getLowerBound().isUnbounded() ? (byte)5 : 0;
        }
        DateRangeBound upperBound = dateRange.getUpperBound().orElseThrow(() -> new IllegalStateException("Upper bound should be set if !isSingleBounded()"));
        if (dateRange.getLowerBound().isUnbounded()) {
            return upperBound.isUnbounded() ? (byte)4 : 3;
        }
        return upperBound.isUnbounded() ? (byte)2 : 1;
    }

    private static void put(ByteBuffer buffer, DateRangeBound bound) {
        buffer.putLong(bound.getTimestamp().toInstant().toEpochMilli());
        buffer.put(bound.getPrecision().getEncoding());
    }

    @Nullable
    public DateRange decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        byte type = bytes.get();
        switch (type) {
            case 0: {
                return new DateRange(DateRangeCodec.decodeLowerBound(bytes));
            }
            case 1: {
                return new DateRange(DateRangeCodec.decodeLowerBound(bytes), DateRangeCodec.decodeUpperBound(bytes));
            }
            case 2: {
                return new DateRange(DateRangeCodec.decodeLowerBound(bytes), DateRangeBound.UNBOUNDED);
            }
            case 3: {
                return new DateRange(DateRangeBound.UNBOUNDED, DateRangeCodec.decodeUpperBound(bytes));
            }
            case 4: {
                return new DateRange(DateRangeBound.UNBOUNDED, DateRangeBound.UNBOUNDED);
            }
            case 5: {
                return new DateRange(DateRangeBound.UNBOUNDED);
            }
        }
        throw new IllegalArgumentException("Unknown date range type: " + type);
    }

    private static DateRangeBound decodeLowerBound(ByteBuffer bytes) {
        long epochMilli = bytes.getLong();
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC);
        DateRangePrecision precision = DateRangePrecision.fromEncoding(bytes.get());
        return DateRangeBound.lowerBound(timestamp, precision);
    }

    private static DateRangeBound decodeUpperBound(ByteBuffer bytes) {
        long epochMilli = bytes.getLong();
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC);
        DateRangePrecision precision = DateRangePrecision.fromEncoding(bytes.get());
        return DateRangeBound.upperBound(timestamp, precision);
    }

    @NonNull
    public String format(@Nullable DateRange dateRange) {
        return dateRange == null ? "NULL" : Strings.quote((String)dateRange.toString());
    }

    @Nullable
    public DateRange parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        try {
            return DateRange.parse(Strings.unquote((String)value));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Invalid date range literal: %s", value), e);
        }
    }
}

