/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.japi;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.japi.CassandraJavaUtil;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.TimestampOption$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.spark.SparkConf;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public abstract class RDDAndDStreamCommonJavaFunctions<T> {
    public abstract CassandraConnector defaultConnector();

    protected abstract SparkConf getConf();

    public WriteConf defaultWriteConf() {
        return WriteConf.fromSparkConf((SparkConf)this.getConf());
    }

    protected abstract void saveToCassandra(String var1, String var2, RowWriterFactory<T> var3, ColumnSelector var4, WriteConf var5, CassandraConnector var6);

    @Deprecated
    public void saveToCassandra(String string, String string2, RowWriterFactory<T> rowWriterFactory, ColumnSelector columnSelector) {
        new WriterBuilder(string, string2, rowWriterFactory, columnSelector, this.defaultConnector(), this.defaultWriteConf()).saveToCassandra();
    }

    public WriterBuilder writerBuilder(String string, String string2, RowWriterFactory<T> rowWriterFactory) {
        return new WriterBuilder(string, string2, rowWriterFactory, CassandraJavaUtil.allColumns, this.defaultConnector(), this.defaultWriteConf());
    }

    public class WriterBuilder
    implements Serializable {
        public final String keyspaceName;
        public final String tableName;
        public final RowWriterFactory<T> rowWriterFactory;
        public final ColumnSelector columnSelector;
        public final CassandraConnector connector;
        public final WriteConf writeConf;

        public WriterBuilder(String string, String string2, RowWriterFactory<T> rowWriterFactory, ColumnSelector columnSelector, CassandraConnector cassandraConnector, WriteConf writeConf) {
            this.keyspaceName = string;
            this.tableName = string2;
            this.rowWriterFactory = rowWriterFactory;
            this.columnSelector = columnSelector;
            this.connector = cassandraConnector;
            this.writeConf = writeConf;
        }

        public WriterBuilder withConnector(CassandraConnector cassandraConnector) {
            if (cassandraConnector != this.connector) {
                return new WriterBuilder(this.keyspaceName, this.tableName, this.rowWriterFactory, this.columnSelector, cassandraConnector, this.writeConf);
            }
            return this;
        }

        public WriterBuilder withWriteConf(WriteConf writeConf) {
            if (writeConf != this.writeConf) {
                return new WriterBuilder(this.keyspaceName, this.tableName, this.rowWriterFactory, this.columnSelector, this.connector, writeConf);
            }
            return this;
        }

        public WriterBuilder withRowWriterFactory(RowWriterFactory<T> rowWriterFactory) {
            return new WriterBuilder(this.keyspaceName, this.tableName, rowWriterFactory, this.columnSelector, this.connector, this.writeConf);
        }

        public WriterBuilder withColumnSelector(ColumnSelector columnSelector) {
            return new WriterBuilder(this.keyspaceName, this.tableName, this.rowWriterFactory, columnSelector, this.connector, this.writeConf);
        }

        public WriterBuilder withBatchSize(BatchSize batchSize) {
            if (!Objects.equals(this.writeConf.batchSize(), batchSize)) {
                return this.withWriteConf(new WriteConf(batchSize, this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withBatchGroupingBufferSize(int n) {
            if (this.writeConf.batchGroupingBufferSize() != n) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), n, this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withBatchGroupingKey(BatchGroupingKey batchGroupingKey) {
            if (!Objects.equals(this.writeConf.batchGroupingKey(), batchGroupingKey)) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), batchGroupingKey, this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withConsistencyLevel(ConsistencyLevel consistencyLevel) {
            if (this.writeConf.consistencyLevel() != consistencyLevel) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), consistencyLevel, this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withParallelismLevel(int n) {
            if (this.writeConf.parallelismLevel() != n) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), n, this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withThroughputMBPS(int n) {
            if (this.writeConf.throughputMiBPS() != (double)n) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), (double)n, this.writeConf.ttl(), this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
            }
            return this;
        }

        public WriterBuilder withTaskMetricsEnabled(boolean bl) {
            if (this.writeConf.taskMetricsEnabled() != bl) {
                return this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), this.writeConf.timestamp(), bl));
            }
            return this;
        }

        private WriterBuilder withTimestamp(TimestampOption timestampOption) {
            return Objects.equals(this.writeConf.timestamp(), timestampOption) ? this : this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), this.writeConf.ttl(), timestampOption, this.writeConf.taskMetricsEnabled()));
        }

        public WriterBuilder withConstantTimestamp(long l) {
            return this.withTimestamp(TimestampOption$.MODULE$.constant(l));
        }

        public WriterBuilder withConstantTimestamp(Date date) {
            long l = date.getTime() * 1000L;
            return this.withConstantTimestamp(l);
        }

        public WriterBuilder withConstantTimestamp(DateTime dateTime) {
            long l = dateTime.getMillis() * 1000L;
            return this.withConstantTimestamp(l);
        }

        public WriterBuilder withAutoTimestamp() {
            return this.withTimestamp(TimestampOption.defaultValue());
        }

        public WriterBuilder withPerRowTimestamp(String string) {
            return this.withTimestamp(TimestampOption$.MODULE$.perRow(string));
        }

        private WriterBuilder withTTL(TTLOption tTLOption) {
            return Objects.equals(this.writeConf.ttl(), tTLOption) ? this : this.withWriteConf(new WriteConf(this.writeConf.batchSize(), this.writeConf.batchGroupingBufferSize(), this.writeConf.batchGroupingKey(), this.writeConf.consistencyLevel(), this.writeConf.parallelismLevel(), this.writeConf.throughputMiBPS(), tTLOption, this.writeConf.timestamp(), this.writeConf.taskMetricsEnabled()));
        }

        public WriterBuilder withConstantTTL(int n) {
            return this.withTTL(TTLOption$.MODULE$.constant(n));
        }

        public WriterBuilder withConstantTTL(Duration duration) {
            int n = (int)duration.getStandardSeconds();
            return this.withConstantTTL(n);
        }

        public WriterBuilder withAutoTTL() {
            return this.withTTL(TTLOption.defaultValue());
        }

        public WriterBuilder withPerRowTTL(String string) {
            return this.withTTL(TTLOption$.MODULE$.perRow(string));
        }

        public void saveToCassandra() {
            RDDAndDStreamCommonJavaFunctions.this.saveToCassandra(this.keyspaceName, this.tableName, this.rowWriterFactory, this.columnSelector, this.writeConf, this.connector);
        }
    }
}

