/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.japi.rdd;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.japi.CassandraJavaUtil;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.EmptyCassandraRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.JavaApiHelper;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import scala.collection.Seq;
import scala.reflect.ClassTag;

public class CassandraJavaRDD<R>
extends JavaRDD<R> {
    public CassandraJavaRDD(CassandraRDD<R> cassandraRDD, Class<R> clazz) {
        super(cassandraRDD, JavaApiHelper.getClassTag(clazz));
    }

    public CassandraJavaRDD(CassandraRDD<R> cassandraRDD, ClassTag<R> classTag) {
        super(cassandraRDD, classTag);
    }

    public CassandraRDD<R> rdd() {
        return (CassandraRDD)super.rdd();
    }

    protected CassandraJavaRDD<R> wrap(CassandraRDD<R> cassandraRDD) {
        return new CassandraJavaRDD<R>(cassandraRDD, this.classTag());
    }

    public CassandraJavaRDD<R> select(String ... stringArray) {
        Seq seq = JavaApiHelper.toScalaSeq((Object)CassandraJavaUtil.toSelectableColumnRefs(stringArray));
        CassandraRDD cassandraRDD = this.rdd().select(seq);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> select(ColumnRef ... columnRefArray) {
        Seq seq = JavaApiHelper.toScalaSeq((Object)columnRefArray);
        CassandraRDD cassandraRDD = this.rdd().select(seq);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> where(String string, Object ... objectArray) {
        CassandraRDD cassandraRDD = this.rdd().where(string, JavaApiHelper.toScalaSeq((Object)objectArray));
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> withAscOrder() {
        CassandraRDD cassandraRDD = this.rdd().withAscOrder();
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> withDescOrder() {
        CassandraRDD cassandraRDD = this.rdd().withDescOrder();
        return this.wrap(cassandraRDD);
    }

    public ColumnRef[] selectedColumnRefs() {
        ClassTag classTag = JavaApiHelper.getClassTag(ColumnRef.class);
        return (ColumnRef[])this.rdd().selectedColumnRefs().toArray(classTag);
    }

    public String[] selectedColumnNames() {
        ClassTag classTag = JavaApiHelper.getClassTag(String.class);
        return (String[])this.rdd().selectedColumnNames().toArray(classTag);
    }

    public CassandraJavaRDD<R> withConnector(CassandraConnector cassandraConnector) {
        CassandraRDD cassandraRDD = this.rdd().withConnector(cassandraConnector);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> withReadConf(ReadConf readConf) {
        CassandraRDD cassandraRDD = this.rdd().withReadConf(readConf);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaRDD<R> limit(Long l) {
        CassandraRDD cassandraRDD = this.rdd().limit(l.longValue());
        return this.wrap(cassandraRDD);
    }

    public <K> JavaPairRDD<K, Iterable<R>> spanBy(Function<R, K> function, ClassTag<K> classTag) {
        return CassandraJavaUtil.javaFunctions(this.rdd()).spanBy(function, classTag);
    }

    public <K> JavaPairRDD<K, Iterable<R>> spanBy(Function<R, K> function, Class<K> clazz) {
        return CassandraJavaUtil.javaFunctions(this.rdd()).spanBy(function, JavaApiHelper.getClassTag(clazz));
    }

    public CassandraJavaRDD<R> toEmptyCassandraRDD() {
        EmptyCassandraRDD emptyCassandraRDD = this.rdd().toEmptyCassandraRDD();
        return this.wrap((CassandraRDD<R>)emptyCassandraRDD);
    }

    public long cassandraCount() {
        return this.rdd().cassandraCount();
    }
}

