/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.spark.connector.TupleValue$;
import com.datastax.spark.connector.UDTValue$;
import com.datastax.spark.connector.util.ByteBufferUtil$;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableView$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;

public final class GettableData$
implements Serializable {
    public static final GettableData$ MODULE$;

    static {
        new GettableData$();
    }

    public Object convert(Object obj, ProtocolVersion protocolVersion) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            object = ByteBufferUtil$.MODULE$.toArray(byteBuffer);
        } else if (object2 instanceof List) {
            List list = (List)object2;
            object = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(list).view().map((Function1)new Serializable(protocolVersion){
                public static final long serialVersionUID = 0L;
                private final ProtocolVersion protocolVersion$1;

                public final Object apply(Object obj) {
                    return GettableData$.MODULE$.convert(obj, this.protocolVersion$1);
                }
                {
                    this.protocolVersion$1 = protocolVersion$1;
                }
            }, SeqView$.MODULE$.canBuildFrom())).toList();
        } else if (object2 instanceof Set) {
            Set set = (Set)object2;
            object = ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(set).view().map((Function1)new Serializable(protocolVersion){
                public static final long serialVersionUID = 0L;
                private final ProtocolVersion protocolVersion$1;

                public final Object apply(Object obj) {
                    return GettableData$.MODULE$.convert(obj, this.protocolVersion$1);
                }
                {
                    this.protocolVersion$1 = protocolVersion$1;
                }
            }, IterableView$.MODULE$.canBuildFrom())).toSet();
        } else if (object2 instanceof Map) {
            Map map = (Map)object2;
            object = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(map).view().map((Function1)new Serializable(protocolVersion){
                public static final long serialVersionUID = 0L;
                private final ProtocolVersion protocolVersion$1;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = new Tuple2(GettableData$.MODULE$.convert(k, this.protocolVersion$1), GettableData$.MODULE$.convert(v, this.protocolVersion$1));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.protocolVersion$1 = protocolVersion$1;
                }
            }, IterableView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        } else if (object2 instanceof UDTValue) {
            UDTValue uDTValue = (UDTValue)object2;
            object = UDTValue$.MODULE$.fromJavaDriverUDTValue(uDTValue, protocolVersion);
        } else if (object2 instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)object2;
            object = TupleValue$.MODULE$.fromJavaDriverTupleValue(tupleValue, protocolVersion);
        } else {
            object = object2;
        }
        return object;
    }

    public Object get(Row row, int index, ProtocolVersion protocolVersion) {
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        DataType columnType = columnDefinitions.getType(index);
        ByteBuffer bytes = row.getBytesUnsafe(index);
        return bytes == null ? null : this.convert(columnType.deserialize(bytes, protocolVersion), protocolVersion);
    }

    public Object get(Row row, String name, ProtocolVersion protocolVersion) {
        int index = row.getColumnDefinitions().getIndexOf(name);
        Predef$.MODULE$.require(index >= 0, (Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column not found in Java driver Row: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
            }
            {
                this.name$1 = name$1;
            }
        });
        return this.get(row, index, protocolVersion);
    }

    public Object get(UDTValue value2, String name, ProtocolVersion protocolVersion) {
        DataType valueType = value2.getType().getFieldType(name);
        ByteBuffer bytes = value2.getBytesUnsafe(name);
        return bytes == null ? null : this.convert(valueType.deserialize(bytes, protocolVersion), protocolVersion);
    }

    public Object get(TupleValue value2, int index, ProtocolVersion protocolVersion) {
        DataType valueType = (DataType)value2.getType().getComponentTypes().get(index);
        ByteBuffer bytes = value2.getBytesUnsafe(index);
        return bytes == null ? null : this.convert(valueType.deserialize(bytes, protocolVersion), protocolVersion);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GettableData$() {
        MODULE$ = this;
    }
}

