/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.ProtocolOptions;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.AuthConf$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.NoAuthConf$;
import com.datastax.spark.connector.util.ConfigCheck$;
import java.net.InetAddress;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple12;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CassandraConnectorConf$
implements Logging,
Serializable {
    public static final CassandraConnectorConf$ MODULE$;
    private final int DefaultPort;
    private final int DefaultKeepAliveMillis;
    private final int DefaultMinReconnectionDelayMillis;
    private final int DefaultMaxReconnectionDelayMillis;
    private final int DefaultQueryRetryCount;
    private final int DefaultConnectTimeoutMillis;
    private final int DefaultReadTimeoutMillis;
    private final ProtocolOptions.Compression DefaultCassandraConnectionCompression;
    private final String CassandraConnectionHostProperty;
    private final String CassandraConnectionPortProperty;
    private final String CassandraConnectionLocalDCProperty;
    private final String CassandraConnectionTimeoutProperty;
    private final String CassandraConnectionKeepAliveProperty;
    private final String CassandraMinReconnectionDelayProperty;
    private final String CassandraMaxReconnectionDelayProperty;
    private final String CassandraConnectionCompressionProperty;
    private final String CassandraQueryRetryCountProperty;
    private final String CassandraReadTimeoutProperty;
    private final Set<String> Properties;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CassandraConnectorConf$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public int DefaultKeepAliveMillis() {
        return this.DefaultKeepAliveMillis;
    }

    public int DefaultMinReconnectionDelayMillis() {
        return this.DefaultMinReconnectionDelayMillis;
    }

    public int DefaultMaxReconnectionDelayMillis() {
        return this.DefaultMaxReconnectionDelayMillis;
    }

    public int DefaultQueryRetryCount() {
        return this.DefaultQueryRetryCount;
    }

    public int DefaultConnectTimeoutMillis() {
        return this.DefaultConnectTimeoutMillis;
    }

    public int DefaultReadTimeoutMillis() {
        return this.DefaultReadTimeoutMillis;
    }

    public ProtocolOptions.Compression DefaultCassandraConnectionCompression() {
        return this.DefaultCassandraConnectionCompression;
    }

    public String CassandraConnectionHostProperty() {
        return this.CassandraConnectionHostProperty;
    }

    public String CassandraConnectionPortProperty() {
        return this.CassandraConnectionPortProperty;
    }

    public String CassandraConnectionLocalDCProperty() {
        return this.CassandraConnectionLocalDCProperty;
    }

    public String CassandraConnectionTimeoutProperty() {
        return this.CassandraConnectionTimeoutProperty;
    }

    public String CassandraConnectionKeepAliveProperty() {
        return this.CassandraConnectionKeepAliveProperty;
    }

    public String CassandraMinReconnectionDelayProperty() {
        return this.CassandraMinReconnectionDelayProperty;
    }

    public String CassandraMaxReconnectionDelayProperty() {
        return this.CassandraMaxReconnectionDelayProperty;
    }

    public String CassandraConnectionCompressionProperty() {
        return this.CassandraConnectionCompressionProperty;
    }

    public String CassandraQueryRetryCountProperty() {
        return this.CassandraQueryRetryCountProperty;
    }

    public String CassandraReadTimeoutProperty() {
        return this.CassandraReadTimeoutProperty;
    }

    public Set<String> Properties() {
        return this.Properties;
    }

    public Option<InetAddress> com$datastax$spark$connector$cql$CassandraConnectorConf$$resolveHost(String hostName) {
        Some some;
        try {
            some = new Some((Object)InetAddress.getByName(hostName));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(hostName){
                public static final long serialVersionUID = 0L;
                private final String hostName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostName$1}));
                }
                {
                    this.hostName$1 = hostName$1;
                }
            }, e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public CassandraConnectorConf apply(SparkConf conf) {
        ConfigCheck$.MODULE$.checkConfig(conf);
        String hostsStr = conf.get(this.CassandraConnectionHostProperty(), InetAddress.getLocalHost().getHostAddress());
        Set hosts2 = (Set)Predef$.MODULE$.refArrayOps((Object[])hostsStr.split(",")).toSet().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<InetAddress> apply(String hostName) {
                return Option$.MODULE$.option2Iterable(CassandraConnectorConf$.MODULE$.com$datastax$spark$connector$cql$CassandraConnectorConf$$resolveHost(hostName).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InetAddress apply(InetAddress hostAddress) {
                        return hostAddress;
                    }
                }));
            }
        }, Set$.MODULE$.canBuildFrom());
        int port = conf.getInt(this.CassandraConnectionPortProperty(), this.DefaultPort());
        AuthConf authConf = AuthConf$.MODULE$.fromSparkConf(conf);
        int keepAlive = conf.getInt(this.CassandraConnectionKeepAliveProperty(), this.DefaultKeepAliveMillis());
        Option localDC = conf.getOption(this.CassandraConnectionLocalDCProperty());
        int minReconnectionDelay = conf.getInt(this.CassandraMinReconnectionDelayProperty(), this.DefaultMinReconnectionDelayMillis());
        int maxReconnectionDelay = conf.getInt(this.CassandraMaxReconnectionDelayProperty(), this.DefaultMaxReconnectionDelayMillis());
        int queryRetryCount = conf.getInt(this.CassandraQueryRetryCountProperty(), this.DefaultQueryRetryCount());
        int connectTimeout = conf.getInt(this.CassandraConnectionTimeoutProperty(), this.DefaultConnectTimeoutMillis());
        int readTimeout = conf.getInt(this.CassandraReadTimeoutProperty(), this.DefaultReadTimeoutMillis());
        ProtocolOptions.Compression compression = (ProtocolOptions.Compression)conf.getOption(this.CassandraConnectionCompressionProperty()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ProtocolOptions.Compression apply(String x$1) {
                return ProtocolOptions.Compression.valueOf((String)x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ProtocolOptions.Compression apply() {
                return CassandraConnectorConf$.MODULE$.DefaultCassandraConnectionCompression();
            }
        });
        CassandraConnectionFactory connectionFactory = CassandraConnectionFactory$.MODULE$.fromSparkConf(conf);
        return new CassandraConnectorConf((Set<InetAddress>)hosts2, port, authConf, (Option<String>)localDC, keepAlive, minReconnectionDelay, maxReconnectionDelay, compression, queryRetryCount, connectTimeout, readTimeout, connectionFactory);
    }

    public int apply$default$2() {
        return this.DefaultPort();
    }

    public AuthConf apply$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public int apply$default$5() {
        return this.DefaultKeepAliveMillis();
    }

    public int apply$default$6() {
        return this.DefaultMinReconnectionDelayMillis();
    }

    public int apply$default$7() {
        return this.DefaultMaxReconnectionDelayMillis();
    }

    public ProtocolOptions.Compression apply$default$8() {
        return this.DefaultCassandraConnectionCompression();
    }

    public int apply$default$9() {
        return this.DefaultQueryRetryCount();
    }

    public int apply$default$10() {
        return this.DefaultConnectTimeoutMillis();
    }

    public int apply$default$11() {
        return this.DefaultReadTimeoutMillis();
    }

    public CassandraConnectionFactory apply$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public CassandraConnectorConf apply(Set<InetAddress> hosts2, int port, AuthConf authConf, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, ProtocolOptions.Compression compression, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory) {
        return new CassandraConnectorConf(hosts2, port, authConf, localDC, keepAliveMillis, minReconnectionDelayMillis, maxReconnectionDelayMillis, compression, queryRetryCount, connectTimeoutMillis, readTimeoutMillis, connectionFactory);
    }

    public Option<Tuple12<Set<InetAddress>, Object, AuthConf, Option<String>, Object, Object, Object, ProtocolOptions.Compression, Object, Object, Object, CassandraConnectionFactory>> unapply(CassandraConnectorConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12(x$0.hosts(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.authConf(), x$0.localDC(), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.minReconnectionDelayMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReconnectionDelayMillis()), (Object)x$0.compression(), (Object)BoxesRunTime.boxToInteger((int)x$0.queryRetryCount()), (Object)BoxesRunTime.boxToInteger((int)x$0.connectTimeoutMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.readTimeoutMillis()), (Object)x$0.connectionFactory()));
    }

    public int $lessinit$greater$default$2() {
        return this.DefaultPort();
    }

    public AuthConf $lessinit$greater$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$5() {
        return this.DefaultKeepAliveMillis();
    }

    public int $lessinit$greater$default$6() {
        return this.DefaultMinReconnectionDelayMillis();
    }

    public int $lessinit$greater$default$7() {
        return this.DefaultMaxReconnectionDelayMillis();
    }

    public ProtocolOptions.Compression $lessinit$greater$default$8() {
        return this.DefaultCassandraConnectionCompression();
    }

    public int $lessinit$greater$default$9() {
        return this.DefaultQueryRetryCount();
    }

    public int $lessinit$greater$default$10() {
        return this.DefaultConnectTimeoutMillis();
    }

    public int $lessinit$greater$default$11() {
        return this.DefaultReadTimeoutMillis();
    }

    public CassandraConnectionFactory $lessinit$greater$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraConnectorConf$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DefaultPort = 9042;
        this.DefaultKeepAliveMillis = 250;
        this.DefaultMinReconnectionDelayMillis = 1000;
        this.DefaultMaxReconnectionDelayMillis = 60000;
        this.DefaultQueryRetryCount = 10;
        this.DefaultConnectTimeoutMillis = 5000;
        this.DefaultReadTimeoutMillis = 12000;
        this.DefaultCassandraConnectionCompression = ProtocolOptions.Compression.NONE;
        this.CassandraConnectionHostProperty = "spark.cassandra.connection.host";
        this.CassandraConnectionPortProperty = "spark.cassandra.connection.port";
        this.CassandraConnectionLocalDCProperty = "spark.cassandra.connection.local_dc";
        this.CassandraConnectionTimeoutProperty = "spark.cassandra.connection.timeout_ms";
        this.CassandraConnectionKeepAliveProperty = "spark.cassandra.connection.keep_alive_ms";
        this.CassandraMinReconnectionDelayProperty = "spark.cassandra.connection.reconnection_delay_ms.min";
        this.CassandraMaxReconnectionDelayProperty = "spark.cassandra.connection.reconnection_delay_ms.max";
        this.CassandraConnectionCompressionProperty = "spark.cassandra.connection.compression";
        this.CassandraQueryRetryCountProperty = "spark.cassandra.query.retry.count";
        this.CassandraReadTimeoutProperty = "spark.cassandra.read.timeout_ms";
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.CassandraConnectionHostProperty(), this.CassandraConnectionPortProperty(), this.CassandraConnectionLocalDCProperty(), this.CassandraConnectionTimeoutProperty(), this.CassandraConnectionKeepAliveProperty(), this.CassandraMinReconnectionDelayProperty(), this.CassandraMaxReconnectionDelayProperty(), this.CassandraConnectionCompressionProperty(), this.CassandraQueryRetryCountProperty(), this.CassandraReadTimeoutProperty()}));
    }
}

