/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$class;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import java.net.InetAddress;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static final DefaultConnectionFactory$ MODULE$;

    static {
        new DefaultConnectionFactory$();
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory$class.properties(this);
    }

    public Cluster.Builder clusterBuilder(CassandraConnectorConf conf) {
        SocketOptions options = new SocketOptions().setConnectTimeoutMillis(conf.connectTimeoutMillis()).setReadTimeoutMillis(conf.readTimeoutMillis());
        return Cluster.builder().addContactPoints((InetAddress[])conf.hosts().toSeq().toArray(ClassTag$.MODULE$.apply(InetAddress.class))).withPort(conf.port()).withRetryPolicy((RetryPolicy)new MultipleRetryPolicy(conf.queryRetryCount())).withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy((long)conf.minReconnectionDelayMillis(), (long)conf.maxReconnectionDelayMillis())).withLoadBalancingPolicy((LoadBalancingPolicy)new LocalNodeFirstLoadBalancingPolicy(conf.hosts(), conf.localDC(), LocalNodeFirstLoadBalancingPolicy$.MODULE$.$lessinit$greater$default$3())).withAuthProvider(conf.authConf().authProvider()).withSocketOptions(options).withCompression(conf.compression());
    }

    @Override
    public Cluster createCluster(CassandraConnectorConf conf) {
        return this.clusterBuilder(conf).build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory$class.$init$(this);
    }
}

