/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.RowCountRef$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableRowReaderProvider;
import com.datastax.spark.connector.rdd.CassandraTableRowReaderProvider$class;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD$;
import com.datastax.spark.connector.rdd.ClusteringOrder;
import com.datastax.spark.connector.rdd.CqlWhereClause;
import com.datastax.spark.connector.rdd.EmptyCassandraRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CassandraRDDPartitioner;
import com.datastax.spark.connector.rdd.partitioner.CassandraRDDPartitioner$;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.NodeAddresses;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory$;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.types.TypeConverter$LongConverter$;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.MagicalTypeTricks$;
import com.datastax.spark.connector.util.Quote$;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}b\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1UC\ndWmU2b]J#EI\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tqQcE\u0002\u0001\u001f\u0005\u00022\u0001E\t\u0014\u001b\u0005\u0011\u0011B\u0001\n\u0003\u00051\u0019\u0015m]:b]\u0012\u0014\u0018M\u0015#E!\t!R\u0003\u0004\u0001\u0005\u000bY\u0001!\u0019A\f\u0003\u0003I\u000b\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011dH\u0005\u0003Ai\u00111!\u00118z!\r\u0001\"eE\u0005\u0003G\t\u0011qdQ1tg\u0006tGM]1UC\ndWMU8x%\u0016\fG-\u001a:Qe>4\u0018\u000eZ3s\u0011!)\u0003A!b\u0001\n\u00031\u0013AA:d+\u00059\u0003C\u0001\u0015/\u001b\u0005I#BA\u0004+\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\n\u0005=J#\u0001D*qCJ\\7i\u001c8uKb$\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0007M\u001c\u0007\u0005\u000b\u00021gA\u0011\u0011\u0004N\u0005\u0003ki\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011\u0015\u0001!Q1A\u0005\u0002]*\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0011\t1aY9m\u0013\ti$H\u0001\nDCN\u001c\u0018M\u001c3sC\u000e{gN\\3di>\u0014\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0015\r|gN\\3di>\u0014\b\u0005\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u00031YW-_:qC\u000e,g*Y7f+\u0005\u0019\u0005C\u0001#H\u001d\tIR)\u0003\u0002G5\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%\u0004\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003D\u00035YW-_:qC\u000e,g*Y7fA!AQ\n\u0001BC\u0002\u0013\u0005!)A\u0005uC\ndWMT1nK\"Aq\n\u0001B\u0001B\u0003%1)\u0001\u0006uC\ndWMT1nK\u0002B\u0001\"\u0015\u0001\u0003\u0006\u0004%\tAU\u0001\fG>dW/\u001c8OC6,7/F\u0001T!\t!V+D\u0001\u0005\u0013\t1FA\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\t\u0011a\u0003!\u0011!Q\u0001\nM\u000bAbY8mk6tg*Y7fg\u0002B\u0001B\u0017\u0001\u0003\u0006\u0004%\taW\u0001\u0006o\",'/Z\u000b\u00029B\u0011\u0001#X\u0005\u0003=\n\u0011abQ9m/\",'/Z\"mCV\u001cX\r\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003]\u0003\u00199\b.\u001a:fA!A!\r\u0001BC\u0002\u0013\u00051-A\u0003mS6LG/F\u0001e!\rIRmZ\u0005\u0003Mj\u0011aa\u00149uS>t\u0007CA\ri\u0013\tI'D\u0001\u0003M_:<\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00023\u0002\r1LW.\u001b;!\u0011!i\u0007A!b\u0001\n\u0003q\u0017aD2mkN$XM]5oO>\u0013H-\u001a:\u0016\u0003=\u00042!G3q!\t\u0001\u0012/\u0003\u0002s\u0005\ty1\t\\;ti\u0016\u0014\u0018N\\4Pe\u0012,'\u000f\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003p\u0003A\u0019G.^:uKJLgnZ(sI\u0016\u0014\b\u0005\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0003!\u0011X-\u00193D_:4W#\u0001=\u0011\u0005AI\u0018B\u0001>\u0003\u0005!\u0011V-\u00193D_:4\u0007\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\u0002\u0013I,\u0017\rZ\"p]\u001a\u0004\u0003\u0002\u0003@\u0001\u0005\u000b\u0007I1A@\u0002\u0011\rd\u0017m]:UC\u001e,\"!!\u0001\u0011\u000b\u0005\r\u0011\u0011B\n\u000e\u0005\u0005\u0015!bAA\u00045\u00059!/\u001a4mK\u000e$\u0018\u0002BA\u0006\u0003\u000b\u0011\u0001b\u00117bgN$\u0016m\u001a\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005\u0005\u0011!C2mCN\u001cH+Y4!\u0011)\t\u0019\u0002\u0001BC\u0002\u0013\r\u0011QC\u0001\u0011e><(+Z1eKJ4\u0015m\u0019;pef,\"!a\u0006\u0011\u000b\u0005e\u0011qD\n\u000e\u0005\u0005m!bAA\u000f\u0005\u00051!/Z1eKJLA!!\t\u0002\u001c\t\u0001\"k\\<SK\u0006$WM\u001d$bGR|'/\u001f\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005]\u0011!\u0005:poJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:zA!\u001a\u00111E\u001a\t\u0011\u0005-\u0002\u0001\"\u0001\u0005\u0003[\ta\u0001P5oSRtD\u0003FA\u0018\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0006\u0004\u00022\u0005M\u0012Q\u0007\t\u0004!\u0001\u0019\u0002b\u0002@\u0002*\u0001\u000f\u0011\u0011\u0001\u0005\t\u0003'\tI\u0003q\u0001\u0002\u0018!1Q%!\u000bA\u0002\u001dBa!BA\u0015\u0001\u0004A\u0004BB!\u0002*\u0001\u00071\t\u0003\u0004N\u0003S\u0001\ra\u0011\u0005\t#\u0006%\u0002\u0013!a\u0001'\"A!,!\u000b\u0011\u0002\u0003\u0007A\f\u0003\u0005c\u0003S\u0001\n\u00111\u0001e\u0011!i\u0017\u0011\u0006I\u0001\u0002\u0004y\u0007\u0002\u0003<\u0002*A\u0005\t\u0019\u0001=\u0006\r\u0005-\u0003\u0001IA\u0019\u0005\u0011\u0019V\r\u001c4\t\u000f\u0005=\u0003\u0001\"\u0015\u0002R\u0005!1m\u001c9z)9\t\u0019&a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\u0002B!!\u0016\u0002J5\t\u0001\u0001\u0003\u0005R\u0003\u001b\u0002\n\u00111\u0001T\u0011!Q\u0016Q\nI\u0001\u0002\u0004a\u0006\u0002\u00032\u0002NA\u0005\t\u0019\u00013\t\u00115\fi\u0005%AA\u0002=D\u0001B^A'!\u0003\u0005\r\u0001\u001f\u0005\t\u000b\u00055\u0003\u0013!a\u0001q!9\u0011Q\r\u0001\u0005R\u0005\u001d\u0014!C2p]Z,'\u000f\u001e+p+\u0011\tI'a\u001c\u0015\r\u0005-\u00141OA=!\u0011\u0001\u0002!!\u001c\u0011\u0007Q\ty\u0007B\u0004\u0002r\u0005\r$\u0019A\f\u0003\u0003\tC!\"!\u001e\u0002d\u0005\u0005\t9AA<\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u0007\tI!!\u001c\t\u0015\u0005m\u00141MA\u0001\u0002\b\ti(\u0001\u0006fm&$WM\\2fII\u0002b!!\u0007\u0002 \u00055\u0004bBAA\u0001\u0011\u0005\u00131Q\u0001\u000eO\u0016$\b+\u0019:uSRLwN\\:\u0016\u0005\u0005\u0015\u0005#B\r\u0002\b\u0006-\u0015bAAE5\t)\u0011I\u001d:bsB\u0019\u0001&!$\n\u0007\u0005=\u0015FA\u0005QCJ$\u0018\u000e^5p]\"Q\u00111\u0013\u0001\t\u0006\u0004%I!!&\u0002\u001b9|G-Z!eIJ,7o]3t+\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\tiJA\u0001\fa\u0006\u0014H/\u001b;j_:,'/\u0003\u0003\u0002\"\u0006m%!\u0004(pI\u0016\fE\r\u001a:fgN,7\u000f\u0003\u0006\u0002&\u0002A\t\u0011)Q\u0005\u0003/\u000baB\\8eK\u0006#GM]3tg\u0016\u001c\b\u0005C\u0004\u0002*\u0002!\t%a+\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR!\u0011QVAc!\u0015\ty+a0D\u001d\u0011\t\t,a/\u000f\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.\r\u0003\u0019a$o\\8u}%\t1$C\u0002\u0002>j\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0006\r'aA*fc*\u0019\u0011Q\u0018\u000e\t\u0011\u0005\u001d\u0017q\u0015a\u0001\u0003\u0017\u000bQa\u001d9mSRDq!a3\u0001\t\u0013\ti-\u0001\u000bu_.,gNU1oO\u0016$vnQ9m#V,'/\u001f\u000b\u0005\u0003\u001f\f9\u000e\u0005\u0004\u001a\u0003#\u001c\u0015Q[\u0005\u0004\u0003'T\"A\u0002+va2,'\u0007E\u0003\u00020\u0006}f\u0004\u0003\u0005\u0002Z\u0006%\u0007\u0019AAn\u0003\u0015\u0011\u0018M\\4f!\u0011\tI*!8\n\t\u0005}\u00171\u0014\u0002\u000e\u0007FdGk\\6f]J\u000bgnZ3\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006y1M]3bi\u0016\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0005\u0002h\u0006](\u0011\u0001B\u0002!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\fAaY8sK*\u0019\u0011\u0011\u001f\u0005\u0002\r\u0011\u0014\u0018N^3s\u0013\u0011\t)0a;\u0003\u0013M#\u0018\r^3nK:$\b\u0002CA}\u0003C\u0004\r!a?\u0002\u000fM,7o]5p]B!\u0011\u0011^A\u007f\u0013\u0011\ty0a;\u0003\u000fM+7o]5p]\"11(!9A\u0002\rC\u0001B!\u0002\u0002b\u0002\u0007!qA\u0001\u0007m\u0006dW/Z:\u0011\te\u0011IAH\u0005\u0004\u0005\u0017Q\"A\u0003\u001fsKB,\u0017\r^3e}!9!q\u0002\u0001\u0005\n\tE\u0011a\u00044fi\u000eDGk\\6f]J\u000bgnZ3\u0015\u0011\tM!\u0011\u0004B\u000e\u0005;\u0001R!a,\u0003\u0016MIAAa\u0006\u0002D\nA\u0011\n^3sCR|'\u000f\u0003\u0005\u0002z\n5\u0001\u0019AA~\u0011!\tIN!\u0004A\u0002\u0005m\u0007\u0002\u0003B\u0010\u0005\u001b\u0001\rA!\t\u0002'%t\u0007/\u001e;NKR\u0014\u0018nY:Va\u0012\fG/\u001a:\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\n*\u0003\u001diW\r\u001e:jGNLAAa\u000b\u0003&\t\u0019\u0012J\u001c9vi6+GO]5dgV\u0003H-\u0019;fe\"9!q\u0006\u0001\u0005B\tE\u0012aB2p[B,H/\u001a\u000b\u0007\u0005'\u0011\u0019D!\u000e\t\u0011\u0005\u001d'Q\u0006a\u0001\u0003\u0017C\u0001Ba\u000e\u0003.\u0001\u0007!\u0011H\u0001\bG>tG/\u001a=u!\rA#1H\u0005\u0004\u0005{I#a\u0003+bg.\u001cuN\u001c;fqRDqA!\u0011\u0001\t\u0003\u0012\u0019%A\nu_\u0016k\u0007\u000f^=DCN\u001c\u0018M\u001c3sCJ#E)\u0006\u0002\u0003FA!\u0001Ca\u0012\u0014\u0013\r\u0011IE\u0001\u0002\u0012\u000b6\u0004H/_\"bgN\fg\u000e\u001a:b%\u0012#\u0005b\u0002B'\u0001\u0011\u0005#qJ\u0001\u0006G>,h\u000e\u001e\u000b\u0002O\"I!1\u000b\u0001\u0012\u0002\u0013E#QK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119FK\u0002T\u00053Z#Aa\u0017\u0011\t\tu#qM\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005KR\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u000eB0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005[\u0002\u0011\u0013!C)\u0005_\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003r)\u001aAL!\u0017\t\u0013\tU\u0004!%A\u0005R\t]\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005sR3\u0001\u001aB-\u0011%\u0011i\bAI\u0001\n#\u0012y(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005%fA8\u0003Z!I!Q\u0011\u0001\u0012\u0002\u0013E#qQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011IIK\u0002y\u00053B\u0011B!$\u0001#\u0003%\tFa$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0013\u0016\u0004q\tesa\u0002BK\u0005!\u0005!qS\u0001\u0016\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f'\u000e\fgN\u0015#E!\r\u0001\"\u0011\u0014\u0004\u0007\u0003\tA\tAa'\u0014\r\te%Q\u0014BR!\rI\"qT\u0005\u0004\u0005CS\"AB!osJ+g\rE\u0002\u001a\u0005KK1Aa*\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\tYC!'\u0005\u0002\t-FC\u0001BL\u0011!\u0011yK!'\u0005\u0002\tE\u0016!B1qa2LX\u0003\u0002BZ\u0005w#\u0002B!.\u0003L\n5'q\u001a\u000b\u0007\u0005o\u0013yL!2\u0011\tA\u0001!\u0011\u0018\t\u0004)\tmFa\u0002B_\u0005[\u0013\ra\u0006\u0002\u0002)\"Q!\u0011\u0019BW\u0003\u0003\u0005\u001dAa1\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0002\u0004\u0005%!\u0011\u0018\u0005\u000b\u0005\u000f\u0014i+!AA\u0004\t%\u0017AC3wS\u0012,gnY3%iA1\u0011\u0011DA\u0010\u0005sCa!\nBW\u0001\u00049\u0003BB!\u0003.\u0002\u00071\t\u0003\u0004N\u0005[\u0003\ra\u0011\u0005\t\u0005_\u0013I\n\"\u0001\u0003TV1!Q\u001bBp\u0005K$\u0002Ba6\u0003|\nu(q \u000b\t\u00053\u0014IOa<\u0003vB!\u0001\u0003\u0001Bn!\u001dI\u0012\u0011\u001bBo\u0005G\u00042\u0001\u0006Bp\t\u001d\u0011\tO!5C\u0002]\u0011\u0011a\u0013\t\u0004)\t\u0015Ha\u0002Bt\u0005#\u0014\ra\u0006\u0002\u0002-\"A!1\u001eBi\u0001\b\u0011i/A\u0003lKf\u001cE\u000b\u0005\u0004\u0002\u0004\u0005%!Q\u001c\u0005\t\u0005c\u0014\t\u000eq\u0001\u0003t\u00069a/\u00197vK\u000e#\u0006CBA\u0002\u0003\u0013\u0011\u0019\u000f\u0003\u0005\u0003x\nE\u00079\u0001B}\u0003\r\u0011(O\u001a\t\u0007\u00033\tyBa7\t\r\u0015\u0012\t\u000e1\u0001(\u0011\u0019\t%\u0011\u001ba\u0001\u0007\"1QJ!5A\u0002\rC!ba\u0001\u0003\u001aF\u0005I\u0011AB\u0003\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU!!QKB\u0004\t\u001912\u0011\u0001b\u0001/!Q11\u0002BM#\u0003%\ta!\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u0011yga\u0004\u0005\rY\u0019IA1\u0001\u0018\u0011)\u0019\u0019B!'\u0012\u0002\u0013\u00051QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\t\t]4q\u0003\u0003\u0007-\rE!\u0019A\f\t\u0015\rm!\u0011TI\u0001\n\u0003\u0019i\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0005\u0005\u007f\u001ay\u0002\u0002\u0004\u0017\u00073\u0011\ra\u0006\u0005\u000b\u0007G\u0011I*%A\u0005\u0002\r\u0015\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0003\u0003\b\u000e\u001dBA\u0002\f\u0004\"\t\u0007q\u0003\u0003\u0006\u0004,\te\u0015\u0011!C\u0005\u0007[\t1B]3bIJ+7o\u001c7wKR\u00111q\u0006\t\u0005\u0007c\u0019Y$\u0004\u0002\u00044)!1QGB\u001c\u0003\u0011a\u0017M\\4\u000b\u0005\re\u0012\u0001\u00026bm\u0006LAa!\u0010\u00044\t1qJ\u00196fGR\u0004")
public class CassandraTableScanRDD<R>
extends CassandraRDD<R>
implements CassandraTableRowReaderProvider<R> {
    private final transient SparkContext sc;
    private final CassandraConnector connector;
    private final String keyspaceName;
    private final String tableName;
    private final ColumnSelector columnNames;
    private final CqlWhereClause where;
    private final Option<Object> limit;
    private final Option<ClusteringOrder> clusteringOrder;
    private final ReadConf readConf;
    private final ClassTag<R> classTag;
    private final transient RowReaderFactory<R> rowReaderFactory;
    private NodeAddresses com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses;
    private final RowReader<Object> rowReader;
    private final TableDef tableDef;
    private final Seq<ColumnRef> selectedColumnRefs;
    private final String cassandraPartitionerClassName;
    private volatile byte bitmap$0;

    public static <R> ReadConf $lessinit$greater$default$9() {
        return CassandraTableScanRDD$.MODULE$.$lessinit$greater$default$9();
    }

    public static <R> Option<ClusteringOrder> $lessinit$greater$default$8() {
        return CassandraTableScanRDD$.MODULE$.$lessinit$greater$default$8();
    }

    public static <R> Option<Object> $lessinit$greater$default$7() {
        return CassandraTableScanRDD$.MODULE$.$lessinit$greater$default$7();
    }

    public static <R> CqlWhereClause $lessinit$greater$default$6() {
        return CassandraTableScanRDD$.MODULE$.$lessinit$greater$default$6();
    }

    public static <R> ColumnSelector $lessinit$greater$default$5() {
        return CassandraTableScanRDD$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, V> CassandraTableScanRDD<Tuple2<K, V>> apply(SparkContext sparkContext, String string, String string2, ClassTag<K> classTag, ClassTag<V> classTag2, RowReaderFactory<Tuple2<K, V>> rowReaderFactory) {
        return CassandraTableScanRDD$.MODULE$.apply(sparkContext, string, string2, classTag, classTag2, rowReaderFactory);
    }

    public static <T> CassandraTableScanRDD<T> apply(SparkContext sparkContext, String string, String string2, ClassTag<T> classTag, RowReaderFactory<T> rowReaderFactory) {
        return CassandraTableScanRDD$.MODULE$.apply(sparkContext, string, string2, classTag, rowReaderFactory);
    }

    private NodeAddresses com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses$lzycompute() {
        CassandraTableScanRDD cassandraTableScanRDD = this;
        synchronized (cassandraTableScanRDD) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses = new NodeAddresses(this.connector());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses;
        }
    }

    private RowReader rowReader$lzycompute() {
        CassandraTableScanRDD cassandraTableScanRDD = this;
        synchronized (cassandraTableScanRDD) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rowReader = CassandraTableRowReaderProvider$class.rowReader(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.rowReader;
        }
    }

    @Override
    public RowReader<R> rowReader() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rowReader$lzycompute() : this.rowReader;
    }

    private TableDef tableDef$lzycompute() {
        CassandraTableScanRDD cassandraTableScanRDD = this;
        synchronized (cassandraTableScanRDD) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tableDef = CassandraTableRowReaderProvider$class.tableDef(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.tableDef;
        }
    }

    @Override
    public TableDef tableDef() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tableDef$lzycompute() : this.tableDef;
    }

    private Seq selectedColumnRefs$lzycompute() {
        CassandraTableScanRDD cassandraTableScanRDD = this;
        synchronized (cassandraTableScanRDD) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.selectedColumnRefs = CassandraTableRowReaderProvider$class.selectedColumnRefs(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.selectedColumnRefs;
        }
    }

    @Override
    public Seq<ColumnRef> selectedColumnRefs() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.selectedColumnRefs$lzycompute() : this.selectedColumnRefs;
    }

    private String cassandraPartitionerClassName$lzycompute() {
        CassandraTableScanRDD cassandraTableScanRDD = this;
        synchronized (cassandraTableScanRDD) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.cassandraPartitionerClassName = CassandraTableRowReaderProvider$class.cassandraPartitionerClassName(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.cassandraPartitionerClassName;
        }
    }

    @Override
    public String cassandraPartitionerClassName() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.cassandraPartitionerClassName$lzycompute() : this.cassandraPartitionerClassName;
    }

    @Override
    public Option<Object> splitCount() {
        return CassandraTableRowReaderProvider$class.splitCount(this);
    }

    @Override
    public int splitSizeInMB() {
        return CassandraTableRowReaderProvider$class.splitSizeInMB(this);
    }

    @Override
    public int fetchSize() {
        return CassandraTableRowReaderProvider$class.fetchSize(this);
    }

    @Override
    public ConsistencyLevel consistencyLevel() {
        return CassandraTableRowReaderProvider$class.consistencyLevel(this);
    }

    @Override
    public Seq<ColumnRef> checkColumnsExistence(Seq<ColumnRef> columns) {
        return CassandraTableRowReaderProvider$class.checkColumnsExistence(this, columns);
    }

    @Override
    public Seq<ColumnRef> narrowColumnSelection(Seq<ColumnRef> columns) {
        return CassandraTableRowReaderProvider$class.narrowColumnSelection(this, columns);
    }

    @Override
    public ProtocolVersion protocolVersion(Session session) {
        return CassandraTableRowReaderProvider$class.protocolVersion(this, session);
    }

    @Override
    public RowReader<R> verify() {
        return CassandraTableRowReaderProvider$class.verify(this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public CassandraConnector connector() {
        return this.connector;
    }

    @Override
    public String keyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public ColumnSelector columnNames() {
        return this.columnNames;
    }

    @Override
    public CqlWhereClause where() {
        return this.where;
    }

    @Override
    public Option<Object> limit() {
        return this.limit;
    }

    @Override
    public Option<ClusteringOrder> clusteringOrder() {
        return this.clusteringOrder;
    }

    @Override
    public ReadConf readConf() {
        return this.readConf;
    }

    @Override
    public ClassTag<R> classTag() {
        return this.classTag;
    }

    @Override
    public RowReaderFactory<R> rowReaderFactory() {
        return this.rowReaderFactory;
    }

    @Override
    public CassandraTableScanRDD<R> copy(ColumnSelector columnNames2, CqlWhereClause where, Option<Object> limit, Option<ClusteringOrder> clusteringOrder, ReadConf readConf, CassandraConnector connector) {
        Predef$.MODULE$.require(this.sc() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RDD transformation requires a non-null SparkContext. Unfortunately SparkContext in this CassandraRDD is null. This can happen after CassandraRDD has been deserialized. SparkContext is not Serializable, therefore it deserializes to null.RDD transformations are not allowed inside lambdas used in other RDD transformations.";
            }
        });
        return new CassandraTableScanRDD<R>(this.sc(), connector, this.keyspaceName(), this.tableName(), columnNames2, where, limit, clusteringOrder, readConf, this.classTag(), this.rowReaderFactory());
    }

    @Override
    public ColumnSelector copy$default$1() {
        return this.columnNames();
    }

    @Override
    public CqlWhereClause copy$default$2() {
        return this.where();
    }

    @Override
    public Option<Object> copy$default$3() {
        return this.limit();
    }

    @Override
    public Option<ClusteringOrder> copy$default$4() {
        return None$.MODULE$;
    }

    @Override
    public ReadConf copy$default$5() {
        return this.readConf();
    }

    @Override
    public CassandraConnector copy$default$6() {
        return this.connector();
    }

    @Override
    public <B> CassandraTableScanRDD<B> convertTo(ClassTag<B> evidence$1, RowReaderFactory<B> evidence$2) {
        return new CassandraTableScanRDD<B>(this.sc(), this.connector(), this.keyspaceName(), this.tableName(), this.columnNames(), this.where(), this.limit(), this.clusteringOrder(), this.readConf(), evidence$1, evidence$2);
    }

    /*
     * WARNING - void declaration
     */
    public Partition[] getPartitions() {
        void var2_2;
        this.verify();
        CassandraRDDPartitioner<Object, Token> partitioner = CassandraRDDPartitioner$.MODULE$.apply(this.connector(), this.tableDef(), this.splitCount(), this.splitSizeInMB());
        Partition[] partitions2 = partitioner.partitions(this.where());
        this.logDebug((Function0)new Serializable(this, partitions2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableScanRDD $outer;
            private final Partition[] partitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created total ", " partitions for ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitions$1.length), this.$outer.keyspaceName(), this.$outer.tableName()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
            }
        });
        this.logTrace((Function0)new Serializable(this, partitions2){
            public static final long serialVersionUID = 0L;
            private final Partition[] partitions$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Partitions: \n").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.partitions$1).mkString("\n")).toString();
            }
            {
                this.partitions$1 = partitions$1;
            }
        });
        return var2_2;
    }

    public NodeAddresses com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses$lzycompute() : this.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses;
    }

    public Seq<String> getPreferredLocations(Partition split2) {
        return ((TraversableOnce)((CassandraPartition)split2).endpoints().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableScanRDD $outer;

            public final Set<String> apply(InetAddress rpcAddress) {
                return this.$outer.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$nodeAddresses().hostNames(rpcAddress);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CqlTokenRange range) {
        String columns = ((TraversableOnce)this.selectedColumnRefs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$1) {
                return x$1.cql();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String string = range.cql();
        String filter = ((TraversableOnce)((TraversableLike)this.where().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
            }
        })).mkString(" AND ");
        String limitClause = (String)this.limit().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(long limit) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIMIT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)limit)}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String orderBy = (String)this.clusteringOrder().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableScanRDD $outer;

            public final String apply(ClusteringOrder x$4) {
                return x$4.toCql(this.$outer.tableDef());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String quotedKeyspaceName = Quote$.MODULE$.quote(this.keyspaceName());
        String quotedTableName = Quote$.MODULE$.quote(this.tableName());
        String queryTemplate = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM ", ".", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedKeyspaceName, quotedTableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE ", " ", " ", " ALLOW FILTERING"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter, orderBy, limitClause}))).toString();
        Seq queryParamValues = (Seq)range.values().$plus$plus(this.where().values(), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
    }

    private Statement createStatement(Session session, String cql, Seq<Object> values) {
        try {
            ProtocolVersion pv = this.protocolVersion(session);
            PreparedStatement stmt = session.prepare(cql);
            stmt.setConsistencyLevel(this.consistencyLevel());
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)stmt.getVariables()).map((Function1)new Serializable(this, pv){
                public static final long serialVersionUID = 0L;
                private final ProtocolVersion pv$1;

                public final TypeConverter<?> apply(ColumnDefinitions.Definition v) {
                    return ColumnType$.MODULE$.converterToCassandra(v.getType(), this.pv$1);
                }
                {
                    this.pv$1 = pv$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, TypeConverter<?>> check$ifrefutable$1) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<Object, TypeConverter<?>> x$5) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = x$5;
                    if (tuple2 != null) {
                        Object value2 = tuple2._1();
                        TypeConverter converter = (TypeConverter)tuple2._2();
                        T t = converter.convert(value2);
                        return t;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            BoundStatement bstm = stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef()));
            bstm.setFetchSize(this.fetchSize());
            return bstm;
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during preparation of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator<R> com$datastax$spark$connector$rdd$CassandraTableScanRDD$$fetchTokenRange(Session session, CqlTokenRange range, InputMetricsUpdater inputMetricsUpdater) {
        Tuple2 tuple22;
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(range);
        if (tuple2 == null) throw new MatchError(tuple2);
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)cql2, (Object)values);
        String cql = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0)new Serializable(this, range, cql, values2){
            public static final long serialVersionUID = 0L;
            private final CqlTokenRange range$1;
            private final String cql$1;
            private final Seq values$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching data for range ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.cql()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cql$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with params ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.values$1.mkString("[", ",", "]")}))).toString();
            }
            {
                void var4_4;
                void var3_3;
                this.range$1 = range$1;
                this.cql$1 = var3_3;
                this.values$1 = var4_4;
            }
        });
        Statement stmt = this.createStatement(session, cql, (Seq<Object>)values2);
        String[] columnNamesArray = (String[])((TraversableOnce)this.selectedColumnRefs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$7) {
                return x$7.selectedAs();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        try {
            ProtocolVersion pv = this.protocolVersion(session);
            ResultSet rs = session.execute(stmt);
            PrefetchingResultSetIterator iterator = new PrefetchingResultSetIterator(rs, this.fetchSize(), PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$3());
            Iterator iteratorWithMetrics = iterator.map(new Serializable(this, inputMetricsUpdater){
                public static final long serialVersionUID = 0L;
                private final InputMetricsUpdater inputMetricsUpdater$1;

                public final Row apply(Row row) {
                    return this.inputMetricsUpdater$1.updateMetrics(row);
                }
                {
                    this.inputMetricsUpdater$1 = inputMetricsUpdater$1;
                }
            });
            Iterator result = iteratorWithMetrics.map((Function1)new Serializable(this, columnNamesArray, pv){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraTableScanRDD $outer;
                private final String[] columnNamesArray$1;
                private final ProtocolVersion pv$2;

                public final R apply(Row x$8) {
                    return this.$outer.rowReader().read(x$8, this.columnNamesArray$1, this.pv$2);
                }
                {
                    void var3_3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.columnNamesArray$1 = columnNamesArray$1;
                    this.pv$2 = var3_3;
                }
            });
            this.logDebug((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final CqlTokenRange range$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Row iterator for range ", " obtained successfully."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.cql()}));
                }
                {
                    this.range$1 = range$1;
                }
            });
            return result;
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during execution of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    public Iterator<R> compute(Partition split2, TaskContext context) {
        Session session = this.connector().openSession();
        CassandraPartition partition = (CassandraPartition)split2;
        Iterable<CqlTokenRange> tokenRanges2 = partition.tokenRanges();
        InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context, this.readConf(), InputMetricsUpdater$.MODULE$.apply$default$3());
        Iterator rowIterator = tokenRanges2.iterator().flatMap((Function1)new Serializable(this, session, metricsUpdater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableScanRDD $outer;
            private final Session session$1;
            private final InputMetricsUpdater metricsUpdater$1;

            public final Iterator<R> apply(CqlTokenRange x$9) {
                return this.$outer.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$fetchTokenRange(this.session$1, x$9, this.metricsUpdater$1);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.session$1 = session$1;
                this.metricsUpdater$1 = var3_3;
            }
        });
        CountingIterator countingIterator = new CountingIterator(rowIterator, this.limit());
        context.addTaskCompletionListener((Function1)new Serializable(this, session, partition, metricsUpdater, countingIterator){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraTableScanRDD $outer;
            private final Session session$1;
            public final CassandraPartition partition$1;
            private final InputMetricsUpdater metricsUpdater$1;
            public final CountingIterator countingIterator$1;

            public final void apply(TaskContext context) {
                double duration = (double)this.metricsUpdater$1.finish() / 1.0E9;
                this.$outer.logDebug((Function0)new Serializable(this, duration){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$compute$1 $outer;
                    private final double duration$1;

                    public final String apply() {
                        Integer arg$1 = BoxesRunTime.boxToInteger((int)this.$outer.countingIterator$1.count());
                        String arg$2 = this.$outer.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$anonfun$$$outer().keyspaceName();
                        String arg$3 = this.$outer.com$datastax$spark$connector$rdd$CassandraTableScanRDD$$anonfun$$$outer().tableName();
                        Integer arg$4 = BoxesRunTime.boxToInteger((int)this.$outer.partition$1.index());
                        double arg$5 = this.duration$1;
                        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Fetched %s rows from %s.%s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2, arg$3}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("for partition %s in %.3f s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$4, BoxesRunTime.boxToDouble((double)arg$5)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.duration$1 = duration$1;
                    }
                });
                this.session$1.close();
            }

            public /* synthetic */ CassandraTableScanRDD com$datastax$spark$connector$rdd$CassandraTableScanRDD$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.session$1 = session$1;
                this.partition$1 = var3_3;
                this.metricsUpdater$1 = var4_4;
                this.countingIterator$1 = var5_5;
            }
        });
        return countingIterator;
    }

    @Override
    public EmptyCassandraRDD<R> toEmptyCassandraRDD() {
        return new EmptyCassandraRDD<R>(this.sc(), this.keyspaceName(), this.tableName(), this.columnNames(), this.where(), this.limit(), this.clusteringOrder(), this.readConf(), this.classTag());
    }

    public long count() {
        SomeColumns someColumns;
        ColumnSelector columnSelector = this.columnNames();
        if (columnSelector instanceof SomeColumns && (someColumns = (SomeColumns)columnSelector).columns() != null && someColumns.columns().lengthCompare(1) == 0) {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "You are about to count rows but an explicit projection has been specified.";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        CassandraTableScanRDD<Object> counts = new CassandraTableScanRDD<Object>(this.sc(), this.connector(), this.keyspaceName(), this.tableName(), new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnRef[]{RowCountRef$.MODULE$})), this.where(), this.limit(), this.clusteringOrder(), this.readConf(), ClassTag$.MODULE$.Long(), RowReaderFactory$.MODULE$.valueRowReaderFactory(TypeConverter$LongConverter$.MODULE$, RowReaderFactory$.MODULE$.isSingleColumnType(TypeConverter$LongConverter$.MODULE$, MagicalTypeTricks$.MODULE$.nsub())));
        return BoxesRunTime.unboxToLong((Object)counts.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$10, long x$11) {
                return this.apply$mcJJJ$sp(x$10, x$11);
            }

            public long apply$mcJJJ$sp(long x$10, long x$11) {
                return x$10 + x$11;
            }
        }));
    }

    public CassandraTableScanRDD(SparkContext sc, CassandraConnector connector, String keyspaceName, String tableName, ColumnSelector columnNames2, CqlWhereClause where, Option<Object> limit, Option<ClusteringOrder> clusteringOrder, ReadConf readConf, ClassTag<R> classTag, RowReaderFactory<R> rowReaderFactory) {
        this.sc = sc;
        this.connector = connector;
        this.keyspaceName = keyspaceName;
        this.tableName = tableName;
        this.columnNames = columnNames2;
        this.where = where;
        this.limit = limit;
        this.clusteringOrder = clusteringOrder;
        this.readConf = readConf;
        this.classTag = classTag;
        this.rowReaderFactory = rowReaderFactory;
        super(sc, (Seq)Seq$.MODULE$.empty(), classTag);
        CassandraTableRowReaderProvider$class.$init$(this);
    }
}

