/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.RateLimiter$;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\tY!+\u0019;f\u0019&l\u0017\u000e^3s\u0015\t\u0019A!\u0001\u0004xe&$XM\u001d\u0006\u0003\u000b\u0019\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003!!\u0017\r^1ti\u0006D(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0011\u0011\u0018\r^3\u0011\u0005=9\u0012B\u0001\r\u0011\u0005\u0011auN\\4\t\u0011i\u0001!\u0011!Q\u0001\nY\t!BY;dW\u0016$8+\u001b>f\u0011!a\u0002A!A!\u0002\u0013i\u0012\u0001\u0002;j[\u0016\u00042a\u0004\u0010\u0017\u0013\ty\u0002CA\u0005Gk:\u001cG/[8oa!A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0003tY\u0016,\u0007\u000f\u0005\u0003\u0010GY)\u0013B\u0001\u0013\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u0010M%\u0011q\u0005\u0005\u0002\u0004\u0003:L\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0003,[9z\u0003\u0007\u0005\u0002-\u00015\t!\u0001C\u0003\u0016Q\u0001\u0007a\u0003C\u0003\u001bQ\u0001\u0007a\u0003C\u0004\u001dQA\u0005\t\u0019A\u000f\t\u000f\u0005B\u0003\u0013!a\u0001E!A!\u0007\u0001b\u0001\n\u0003\u00111'\u0001\u0006ck\u000e\\W\r\u001e$jY2,\u0012\u0001\u000e\t\u0003kyj\u0011A\u000e\u0006\u0003oa\na!\u0019;p[&\u001c'BA\u001d;\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wq\nA!\u001e;jY*\tQ(\u0001\u0003kCZ\f\u0017BA 7\u0005)\tEo\\7jG2{gn\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001b\u0002\u0017\t,8m[3u\r&dG\u000e\t\u0005\t\u0007\u0002\u0011\r\u0011\"\u0001\u0003g\u0005AA.Y:u)&lW\r\u0003\u0004F\u0001\u0001\u0006I\u0001N\u0001\nY\u0006\u001cH\u000fV5nK\u0002BQa\u0012\u0001\u0005\n!\u000bA\u0001\\3bWR\u0011\u0011\n\u0014\t\u0003\u001f)K!a\u0013\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\u001a\u0003\rAF\u0001\u0007i>dU-Y6)\u0005\u0019{\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003)F\u0013q\u0001^1jYJ,7\r\u0003\u0004H\u0001\u0011\u0005!A\u0016\u000b\u0002\u0013\")\u0001\f\u0001C\u00013\u0006QQ.Y=cKNcW-\u001a9\u0015\u0005%S\u0006\"B.X\u0001\u00041\u0012A\u00039bG.,GoU5{K\u001e9QLAA\u0001\u0012\u0003q\u0016a\u0003*bi\u0016d\u0015.\\5uKJ\u0004\"\u0001L0\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001AN\u0011qL\u0004\u0005\u0006S}#\tA\u0019\u000b\u0002=\"9AmXI\u0001\n\u0003)\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001gU\tirmK\u0001i!\tIG.D\u0001k\u0015\tY\u0017+A\u0005v]\u000eDWmY6fI&\u0011QN\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB8`#\u0003%\t\u0001]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003ET#AI4")
public class RateLimiter {
    private final long rate;
    private final long bucketSize;
    private final Function0<Object> time;
    private final Function1<Object, Object> sleep;
    private final AtomicLong bucketFill;
    private final AtomicLong lastTime;

    public static Function1<Object, Object> $lessinit$greater$default$4() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0<Object> $lessinit$greater$default$3() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$3();
    }

    public AtomicLong bucketFill() {
        return this.bucketFill;
    }

    public AtomicLong lastTime() {
        return this.lastTime;
    }

    private void leak(long toLeak) {
        while (true) {
            long fill = this.bucketFill().get();
            long reallyToLeak = package$.MODULE$.min(fill, toLeak);
            if (!this.bucketFill().compareAndSet(fill, fill - reallyToLeak)) continue;
            return;
        }
    }

    public void leak() {
        long currentTime = this.time.apply$mcJ$sp();
        long prevTime = this.lastTime().getAndSet(currentTime);
        long elapsedTime = package$.MODULE$.max(currentTime - prevTime, 0L);
        this.leak(elapsedTime * this.rate / 1000L);
    }

    public void maybeSleep(long packetSize) {
        this.leak();
        long currentFill = this.bucketFill().addAndGet(packetSize);
        long overflow = currentFill - this.bucketSize;
        long delay = 1000L * overflow / this.rate;
        if (delay > 0L) {
            this.sleep.apply((Object)BoxesRunTime.boxToLong((long)delay));
        }
    }

    public RateLimiter(long rate, long bucketSize, Function0<Object> time, Function1<Object, Object> sleep) {
        this.rate = rate;
        this.bucketSize = bucketSize;
        this.time = time;
        this.sleep = sleep;
        Predef$.MODULE$.require(rate > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A positive rate is required";
            }
        });
        Predef$.MODULE$.require(bucketSize > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A positive bucket size is required";
            }
        });
        this.bucketFill = new AtomicLong(0L);
        this.lastTime = new AtomicLong(time.apply$mcJ$sp());
    }
}

