/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TableWriter;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.IOException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.Nothing$;

public final class TableWriter$
implements Serializable {
    public static final TableWriter$ MODULE$;

    static {
        new TableWriter$();
    }

    private void checkColumns(TableDef table, Seq<String> columnNames2) {
        this.checkMissingColumns(table, columnNames2);
        this.checkMissingPrimaryKeyColumns(table, columnNames2);
    }

    private void checkMissingColumns(TableDef table, Seq<String> columnNames2) {
        IndexedSeq allColumnNames = (IndexedSeq)table.columns().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$15) {
                return x$15.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set missingColumns2 = (Set)columnNames2.toSet().$minus$minus((GenTraversableOnce)allColumnNames);
        if (missingColumns2.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column(s) not found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingColumns2.mkString(", ")})));
        }
    }

    private void checkMissingPrimaryKeyColumns(TableDef table, Seq<String> columnNames2) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)table.primaryKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$16) {
                return x$16.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set missingPrimaryKeyColumns = (Set)primaryKeyColumnNames.toSet().$minus$minus(columnNames2);
        if (missingPrimaryKeyColumns.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some primary key columns are missing in RDD or have not been selected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingPrimaryKeyColumns.mkString(", ")})));
        }
    }

    public <T> TableWriter<T> apply(CassandraConnector connector, String keyspaceName, String tableName, ColumnSelector columnNames2, WriteConf writeConf, RowWriterFactory<T> evidence$1) {
        Schema schema2 = Schema$.MODULE$.fromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName));
        TableDef tableDef = (TableDef)schema2.tables().headOption().getOrElse((Function0)new Serializable(keyspaceName, tableName){
            public static final long serialVersionUID = 0L;
            private final String keyspaceName$1;
            private final String tableName$1;

            public final Nothing$ apply() {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table not found: ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspaceName$1, this.tableName$1})));
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
                this.tableName$1 = tableName$1;
            }
        });
        IndexedSeq<ColumnRef> selectedColumns = columnNames2.selectFrom(tableDef);
        Seq optionColumns = (Seq)writeConf.optionsAsColumns().apply((Object)keyspaceName, (Object)tableName);
        Seq x$19 = (Seq)tableDef.regularColumns().$plus$plus((GenTraversableOnce)optionColumns, Seq$.MODULE$.canBuildFrom());
        String x$20 = tableDef.copy$default$1();
        String x$21 = tableDef.copy$default$2();
        Seq<ColumnDef> x$22 = tableDef.copy$default$3();
        Seq<ColumnDef> x$23 = tableDef.copy$default$4();
        RowWriter rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(evidence$1)).rowWriter(tableDef.copy(x$20, x$21, x$22, x$23, (Seq<ColumnDef>)x$19), (IndexedSeq<ColumnRef>)((IndexedSeq)selectedColumns.$plus$plus((GenTraversableOnce)optionColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(ColumnDef x$17) {
                return x$17.ref();
            }
        }, Seq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
        this.checkColumns(tableDef, (Seq<String>)((Seq)selectedColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$18) {
                return x$18.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        return new TableWriter(connector, tableDef, rowWriter, writeConf);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TableWriter$() {
        MODULE$ = this;
    }
}

