/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tqQg\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033}i\u0011A\u0007\u0006\u0003\u000fmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001E\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003O\u0011\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0005uC\ndW\rR3g!\t\u00193&\u0003\u0002-I\tAA+\u00192mK\u0012+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003%\u0011xn^,sSR,'\u000fE\u00021cMj\u0011AA\u0005\u0003e\t\u0011\u0011BU8x/JLG/\u001a:\u0011\u0005Q*D\u0002\u0001\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0002)F\u0011\u0001h\u000f\t\u0003!eJ!AO\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0003P\u0005\u0003{E\u00111!\u00118z\u0011!y\u0004A!A!\u0002\u0013\u0001\u0015!C<sSR,7i\u001c8g!\t\u0001\u0014)\u0003\u0002C\u0005\tIqK]5uK\u000e{gN\u001a\u0005\u0006\t\u0002!I!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019;\u0005*\u0013&\u0011\u0007A\u00021\u0007C\u0003\u0006\u0007\u0002\u0007!\u0005C\u0003*\u0007\u0002\u0007!\u0006C\u0003/\u0007\u0002\u0007q\u0006C\u0003@\u0007\u0002\u0007\u0001\tC\u0004M\u0001\t\u0007I\u0011A'\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0016\u00039\u0003\"a\u0014*\u000f\u0005A\u0001\u0016BA)\u0012\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u000b\u0002B\u0002,\u0001A\u0003%a*A\u0007lKf\u001c\b/Y2f\u001d\u0006lW\r\t\u0005\b1\u0002\u0011\r\u0011\"\u0001N\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0004[\u0001\u0001\u0006IAT\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003b\u0002/\u0001\u0005\u0004%\t!X\u0001\fG>dW/\u001c8OC6,7/F\u0001_!\ry&MT\u0007\u0002A*\u0011\u0011-E\u0001\u000bG>dG.Z2uS>t\u0017BA2a\u0005\r\u0019V-\u001d\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\t\u000f\u001d\u0004!\u0019!C\u0001Q\u000691m\u001c7v[:\u001cX#A5\u0011\u0007}\u0013'\u000e\u0005\u0002$W&\u0011A\u000e\n\u0002\n\u0007>dW/\u001c8EK\u001aDaA\u001c\u0001!\u0002\u0013I\u0017\u0001C2pYVlgn\u001d\u0011\t\u000fA\u0004!\u0019!C\u0002c\u0006y\u0001O]8u_\u000e|GNV3sg&|g.F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003d_J,'BA<\t\u0003\u0019!'/\u001b<fe&\u0011\u0011\u0010\u001e\u0002\u0010!J|Go\\2pYZ+'o]5p]\"11\u0010\u0001Q\u0001\nI\f\u0001\u0003\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0011\t\u000fu\u0004!\u0019!C\u0001}\u0006QA-\u001a4bk2$H\u000b\u0016'\u0016\u0003}\u0004R\u0001EA\u0001\u0003\u000bI1!a\u0001\u0012\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001#a\u0002\n\u0007\u0005%\u0011CA\u0002J]RDq!!\u0004\u0001A\u0003%q0A\u0006eK\u001a\fW\u000f\u001c;U)2\u0003\u0003\"CA\t\u0001\t\u0007I\u0011AA\n\u0003A!WMZ1vYR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002\u0016A)\u0001#!\u0001\u0002\u0018A\u0019\u0001#!\u0007\n\u0007\u0005m\u0011C\u0001\u0003M_:<\u0007\u0002CA\u0010\u0001\u0001\u0006I!!\u0006\u0002#\u0011,g-Y;miRKW.Z:uC6\u0004\b\u0005\u0003\u0006\u0002$\u0001A)\u0019!C\u0001\t5\u000b\u0001$];fef$V-\u001c9mCR,Wk]5oO&s7/\u001a:u\u0011%\t9\u0003\u0001E\u0001B\u0003&a*A\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<\u0017J\\:feR\u0004\u0003\"CA\u0016\u0001!\u0015\r\u0011\"\u0003N\u0003a\tX/\u001a:z)\u0016l\u0007\u000f\\1uKV\u001b\u0018N\\4Va\u0012\fG/\u001a\u0005\n\u0003_\u0001\u0001\u0012!Q!\n9\u000b\u0011$];fef$V-\u001c9mCR,Wk]5oOV\u0003H-\u0019;fA!I\u00111\u0007\u0001C\u0002\u0013%\u0011QG\u0001\u0010SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uKV\u0011\u0011q\u0007\t\u0004!\u0005e\u0012bAA\u001e#\t9!i\\8mK\u0006t\u0007\u0002CA \u0001\u0001\u0006I!a\u000e\u0002!%\u001c8i\\;oi\u0016\u0014X\u000b\u001d3bi\u0016\u0004\u0003\u0002CA\"\u0001\t\u0007I\u0011B'\u0002\u001bE,XM]=UK6\u0004H.\u0019;f\u0011\u001d\t9\u0005\u0001Q\u0001\n9\u000ba\"];fef$V-\u001c9mCR,\u0007\u0005C\u0004\u0002L\u0001!I!!\u0014\u0002!A\u0014X\r]1sKN#\u0018\r^3nK:$H\u0003BA(\u0003+\u00022a]A)\u0013\r\t\u0019\u0006\u001e\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\b\u0002CA,\u0003\u0013\u0002\r!!\u0017\u0002\u000fM,7o]5p]B\u00191/a\u0017\n\u0007\u0005uCOA\u0004TKN\u001c\u0018n\u001c8\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005y!-\u0019;dQJ{W\u000f^5oO.+\u0017\u0010\u0006\u0004\u0002f\u0005E\u00141\u000f\u000b\u0004w\u0005\u001d\u0004\u0002CA5\u0003?\u0002\r!a\u001b\u0002\u0005\t\u001c\bcA:\u0002n%\u0019\u0011q\u000e;\u0003\u001d\t{WO\u001c3Ti\u0006$X-\\3oi\"A\u0011qKA0\u0001\u0004\tI\u0006\u0003\u0005\u0002v\u0005}\u0003\u0019AA<\u0003M\u0011x.\u001e;j]\u001e\\U-_$f]\u0016\u0014\u0018\r^8s!\r\u0001\u0014\u0011P\u0005\u0004\u0003w\u0012!a\u0005*pkRLgnZ&fs\u001e+g.\u001a:bi>\u0014\bbBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0006oJLG/\u001a\u000b\u0007\u0003\u0007\u000bI)a%\u0011\u0007A\t))C\u0002\u0002\bF\u0011A!\u00168ji\"A\u00111RA?\u0001\u0004\ti)A\u0006uCN\\7i\u001c8uKb$\bcA\r\u0002\u0010&\u0019\u0011\u0011\u0013\u000e\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\t\u0003+\u000bi\b1\u0001\u0002\u0018\u0006!A-\u0019;b!\u0011y\u0016\u0011T\u001a\n\u0007\u0005m\u0005M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u000f\u001d\tyJ\u0001E\u0001\u0003C\u000b1\u0002V1cY\u0016<&/\u001b;feB\u0019\u0001'a)\u0007\r\u0005\u0011\u0001\u0012AAS'\u0011\t\u0019kD\u000b\t\u000f\u0011\u000b\u0019\u000b\"\u0001\u0002*R\u0011\u0011\u0011\u0015\u0005\t\u0003[\u000b\u0019\u000b\"\u0003\u00020\u0006a1\r[3dW\u000e{G.^7ogR1\u00111QAY\u0003kCq!a-\u0002,\u0002\u0007!&A\u0003uC\ndW\r\u0003\u0004]\u0003W\u0003\rA\u0018\u0005\t\u0003s\u000b\u0019\u000b\"\u0003\u0002<\u0006\u00192\r[3dW6K7o]5oO\u000e{G.^7ogR1\u00111QA_\u0003\u007fCq!a-\u00028\u0002\u0007!\u0006\u0003\u0004]\u0003o\u0003\rA\u0018\u0005\t\u0003\u0007\f\u0019\u000b\"\u0003\u0002F\u0006i2\r[3dW6K7o]5oOB\u0013\u0018.\\1ss.+\u0017pQ8mk6t7\u000f\u0006\u0004\u0002\u0004\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003g\u000b\t\r1\u0001+\u0011\u0019a\u0016\u0011\u0019a\u0001=\"A\u0011QZAR\t\u0003\ty-A\u0003baBd\u00170\u0006\u0003\u0002R\u0006eG\u0003DAj\u0003K\f9/!;\u0002l\u0006UH\u0003BAk\u00037\u0004B\u0001\r\u0001\u0002XB\u0019A'!7\u0005\rY\nYM1\u00018\u0011)\ti.a3\u0002\u0002\u0003\u000f\u0011q\\\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#\u0002\u0019\u0002b\u0006]\u0017bAAr\u0005\t\u0001\"k\\<Xe&$XM\u001d$bGR|'/\u001f\u0005\u0007\u000b\u0005-\u0007\u0019\u0001\u0012\t\r1\u000bY\r1\u0001O\u0011\u0019A\u00161\u001aa\u0001\u001d\"9A,a3A\u0002\u00055\b\u0003BAx\u0003cl\u0011\u0001B\u0005\u0004\u0003g$!AD\"pYVlgnU3mK\u000e$xN\u001d\u0005\u0007\u007f\u0005-\u0007\u0019\u0001!\t\u0015\u0005e\u00181UA\u0001\n\u0013\tY0A\u0006sK\u0006$'+Z:pYZ,GCAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\tA\u0001\\1oO*\u0011!qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\f\t\u0005!AB(cU\u0016\u001cG\u000f")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final TableDef com$datastax$spark$connector$writer$TableWriter$$tableDef;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    public final WriteConf com$datastax$spark$connector$writer$TableWriter$$writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private final ProtocolVersion protocolVersion;
    private final Option<Object> defaultTTL;
    private final Option<Object> defaultTimestamp;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    private final String queryTemplate;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, rowWriterFactory);
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                WriteOptionValue<Object> writeOptionValue3;
                None$ none$2;
                WriteOptionValue<Object> writeOptionValue4;
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2) {
                        return new StringBuilder().append((Object)":").append((Object)x$2).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                if (tTLOption != null && (writeOptionValue4 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue4;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (tTLOption != null && (writeOptionValue3 = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue3;
                    int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value2)})));
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ ttlSpec = none$2;
                TimestampOption timestampOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder3 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder3})));
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value3 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)value3)})));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ timestampSpec = none$;
                List options = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ttlSpec, timestampSpec})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                String optionsSpec = options.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.mkString(" AND ")})) : "";
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), columnSpec, valueSpec, optionsSpec})).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new $anonfun$5(this));
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new $anonfun$6(this));
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Seq setNonCounterColumnsClause = (Seq)this.quotedColumnNames$1(nonCounterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$1(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause2 = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), setClause, whereClause2}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public Option<Object> defaultTTL() {
        return this.defaultTTL;
    }

    public Option<Object> defaultTimestamp() {
        return this.defaultTimestamp;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    public boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() {
        return this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    }

    private String queryTemplate() {
        return this.queryTemplate;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(Session session) {
        try {
            return session.prepare(this.queryTemplate());
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queryTemplate()}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    public Object batchRoutingKey(Session session, RoutingKeyGenerator routingKeyGenerator, BoundStatement bs) {
        BatchGroupingKey batchGroupingKey;
        block5: {
            Comparable<Integer> comparable;
            block3: {
                block4: {
                    block2: {
                        batchGroupingKey = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingKey();
                        BatchGroupingKey$None$ batchGroupingKey$None$ = BatchGroupingKey$None$.MODULE$;
                        BatchGroupingKey batchGroupingKey2 = batchGroupingKey;
                        if (batchGroupingKey$None$ != null ? !batchGroupingKey$None$.equals(batchGroupingKey2) : batchGroupingKey2 != null) break block2;
                        comparable = BoxesRunTime.boxToInteger((int)0);
                        break block3;
                    }
                    BatchGroupingKey$ReplicaSet$ batchGroupingKey$ReplicaSet$ = BatchGroupingKey$ReplicaSet$.MODULE$;
                    BatchGroupingKey batchGroupingKey3 = batchGroupingKey;
                    if (batchGroupingKey$ReplicaSet$ != null ? !batchGroupingKey$ReplicaSet$.equals(batchGroupingKey3) : batchGroupingKey3 != null) break block4;
                    Object object = bs.getRoutingKey() == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                    comparable = BoxesRunTime.boxToInteger((int)((Object)session.getCluster().getMetadata().getReplicas(this.keyspaceName(), bs.getRoutingKey())).hashCode());
                    break block3;
                }
                BatchGroupingKey$Partition$ batchGroupingKey$Partition$ = BatchGroupingKey$Partition$.MODULE$;
                BatchGroupingKey batchGroupingKey4 = batchGroupingKey;
                if (batchGroupingKey$Partition$ != null ? !batchGroupingKey$Partition$.equals(batchGroupingKey4) : batchGroupingKey4 != null) break block5;
                Object object = bs.getRoutingKey() == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                comparable = bs.getRoutingKey().duplicate();
            }
            return comparable;
        }
        throw new MatchError((Object)batchGroupingKey);
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.com$datastax$spark$connector$writer$TableWriter$$writeConf);
        this.connector.withSessionDo(new Serializable(this, data, updater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final Iterator data$1;
            public final OutputMetricsUpdater updater$1;

            public final void apply(Session session) {
                CountingIterator<T> rowIterator = new CountingIterator<T>(this.data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
                PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(session).setConsistencyLevel(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                QueryExecutor queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final void apply(RichStatement x$9, long x$10, long x$11) {
                        this.$outer.updater$1.batchFinished(true, x$9, x$10, x$11);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final void apply(RichStatement x$12, long x$13, long x$14) {
                        this.$outer.updater$1.batchFinished(false, x$12, x$13, x$14);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator(this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef, this.$outer.columnNames());
                BatchStatement.Type batchType = this.$outer.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? BatchStatement.Type.COUNTER : BatchStatement.Type.UNLOGGED;
                BoundStatementBuilder<T> boundStmtBuilder = new BoundStatementBuilder<T>(this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter, stmt, this.$outer.protocolVersion(), BoundStatementBuilder$.MODULE$.$lessinit$greater$default$4());
                BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder(batchType, routingKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                Serializable batchKeyGenerator = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;
                    private final Session session$1;
                    private final RoutingKeyGenerator routingKeyGenerator$1;

                    public final Object apply(BoundStatement bs) {
                        return this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().batchRoutingKey(this.session$1, this.routingKeyGenerator$1, bs);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.session$1 = session$1;
                        this.routingKeyGenerator$1 = routingKeyGenerator$1;
                    }
                };
                GroupingBatchBuilder<T> batchBuilder = new GroupingBatchBuilder<T>(boundStmtBuilder, batchStmtBuilder, (Function1<BoundStatement, Object>)batchKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingBufferSize(), rowIterator);
                RateLimiter rateLimiter = new RateLimiter((long)this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.throughputMiBPS() * 1024L * 1024L, 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                batchBuilder.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final QueryExecutor queryExecutor$1;
                    private final RateLimiter rateLimiter$1;

                    public final void apply(RichStatement stmtToWrite) {
                        this.queryExecutor$1.executeAsync(stmtToWrite);
                        Predef$.MODULE$.assert(stmtToWrite.bytesCount() > 0);
                        this.rateLimiter$1.maybeSleep(stmtToWrite.bytesCount());
                    }
                    {
                        this.queryExecutor$1 = queryExecutor$1;
                        this.rateLimiter$1 = rateLimiter$1;
                    }
                });
                queryExecutor.waitForCurrentlyExecutingTasks();
                if (queryExecutor.successful()) {
                    double duration = (double)this.updater$1.finish() / 1.0E9;
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$write$1 $outer;
                        private final CountingIterator rowIterator$1;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$1 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                            String arg$2 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                            String arg$3 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                            double arg$4 = this.duration$1;
                            return new StringOps(Predef$.MODULE$.augmentString("Wrote %s rows to %s.%s in %.3f s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2, arg$3, BoxesRunTime.boxToDouble((double)arg$4)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rowIterator$1 = rowIterator$1;
                            this.duration$1 = duration$1;
                        }
                    });
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write statements to ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.keyspaceName(), this.$outer.tableName()})));
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.data$1 = data$1;
                this.updater$1 = var3_3;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$7) {
                return x$7.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, RowWriter<T> rowWriter, WriteConf writeConf) {
        None$ none$;
        WriteOptionValue<Object> writeOptionValue;
        None$ none$2;
        WriteOptionValue<Object> writeOptionValue2;
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$tableDef = tableDef;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.com$datastax$spark$connector$writer$TableWriter$$writeConf = writeConf;
        Logging.class.$init$((Logging)this);
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.protocolVersion = (ProtocolVersion)connector.withClusterDo(new $anonfun$1(this));
        TTLOption tTLOption = writeConf.ttl();
        if (tTLOption != null && (writeOptionValue2 = tTLOption.value()) instanceof StaticWriteOptionValue) {
            StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue2;
            int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
            none$2 = new Some((Object)BoxesRunTime.boxToInteger((int)value2));
        } else {
            none$2 = None$.MODULE$;
        }
        this.defaultTTL = none$2;
        TimestampOption timestampOption = writeConf.timestamp();
        if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
            StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
            long value3 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)value3));
        } else {
            none$ = None$.MODULE$;
        }
        this.defaultTimestamp = none$;
        this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate = tableDef.columns().exists((Function1)new $anonfun$10(this));
        this.queryTemplate = this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? this.queryTemplateUsingUpdate() : this.queryTemplateUsingInsert();
    }
}

