/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.BatchSize$;
import com.datastax.spark.connector.BytesInBatch;
import com.datastax.spark.connector.RowsInBatch;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.TimestampOption$;
import com.datastax.spark.connector.writer.WriteConf;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.spark.SparkConf;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple9;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class WriteConf$
implements Serializable {
    public static final WriteConf$ MODULE$;
    private final String WriteBatchSizeInBytesProperty;
    private final String WriteConsistencyLevelProperty;
    private final String WriteBatchSizeInRowsProperty;
    private final String WriteBatchBufferSizeProperty;
    private final String WriteBatchLevelProperty;
    private final String WriteParallelismLevelProperty;
    private final String WriteThroughputMiBPS;
    private final String WriteTaskMetricsProperty;
    private final Set<String> Properties;
    private final ConsistencyLevel DefaultConsistencyLevel;
    private final int DefaultBatchSizeInBytes;
    private final int DefaultParallelismLevel;
    private final int DefaultBatchGroupingBufferSize;
    private final BatchGroupingKey$Partition$ DefaultBatchGroupingKey;
    private final int DefaultThroughputMiBPS;
    private final boolean DefaultWriteTaskMetricsEnabled;

    static {
        new WriteConf$();
    }

    public String WriteBatchSizeInBytesProperty() {
        return this.WriteBatchSizeInBytesProperty;
    }

    public String WriteConsistencyLevelProperty() {
        return this.WriteConsistencyLevelProperty;
    }

    public String WriteBatchSizeInRowsProperty() {
        return this.WriteBatchSizeInRowsProperty;
    }

    public String WriteBatchBufferSizeProperty() {
        return this.WriteBatchBufferSizeProperty;
    }

    public String WriteBatchLevelProperty() {
        return this.WriteBatchLevelProperty;
    }

    public String WriteParallelismLevelProperty() {
        return this.WriteParallelismLevelProperty;
    }

    public String WriteThroughputMiBPS() {
        return this.WriteThroughputMiBPS;
    }

    public String WriteTaskMetricsProperty() {
        return this.WriteTaskMetricsProperty;
    }

    public Set<String> Properties() {
        return this.Properties;
    }

    public ConsistencyLevel DefaultConsistencyLevel() {
        return this.DefaultConsistencyLevel;
    }

    public int DefaultBatchSizeInBytes() {
        return this.DefaultBatchSizeInBytes;
    }

    public int DefaultParallelismLevel() {
        return this.DefaultParallelismLevel;
    }

    public int DefaultBatchGroupingBufferSize() {
        return this.DefaultBatchGroupingBufferSize;
    }

    public BatchGroupingKey$Partition$ DefaultBatchGroupingKey() {
        return this.DefaultBatchGroupingKey;
    }

    public int DefaultThroughputMiBPS() {
        return this.DefaultThroughputMiBPS;
    }

    public boolean DefaultWriteTaskMetricsEnabled() {
        return this.DefaultWriteTaskMetricsEnabled;
    }

    public WriteConf fromSparkConf(SparkConf conf) {
        String string;
        block4: {
            Product product;
            ConsistencyLevel consistencyLevel;
            block3: {
                Regex Number2;
                block2: {
                    ConfigCheck$.MODULE$.checkConfig(conf);
                    int batchSizeInBytes = conf.getInt(this.WriteBatchSizeInBytesProperty(), this.DefaultBatchSizeInBytes());
                    consistencyLevel = ConsistencyLevel.valueOf((String)conf.get(this.WriteConsistencyLevelProperty(), this.DefaultConsistencyLevel().name()));
                    String batchSizeInRowsStr = conf.get(this.WriteBatchSizeInRowsProperty(), "auto");
                    Number2 = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)")).r();
                    String string2 = string = batchSizeInRowsStr;
                    if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block2;
                    product = new BytesInBatch(batchSizeInBytes);
                    break block3;
                }
                Option option = Number2.unapplySeq((Object)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                product = new RowsInBatch(new StringOps(Predef$.MODULE$.augmentString(x)).toInt());
            }
            BytesInBatch batchSize = product;
            int batchBufferSize = conf.getInt(this.WriteBatchBufferSizeProperty(), this.DefaultBatchGroupingBufferSize());
            BatchGroupingKey batchGroupingKey = (BatchGroupingKey)conf.getOption(this.WriteBatchLevelProperty()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BatchGroupingKey apply(String name) {
                    return BatchGroupingKey$.MODULE$.apply(name);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BatchGroupingKey$Partition$ apply() {
                    return WriteConf$.MODULE$.DefaultBatchGroupingKey();
                }
            });
            int parallelismLevel = conf.getInt(this.WriteParallelismLevelProperty(), this.DefaultParallelismLevel());
            int throughputMiBPS = conf.getInt(this.WriteThroughputMiBPS(), this.DefaultThroughputMiBPS());
            boolean metricsEnabled = conf.getBoolean(this.WriteTaskMetricsProperty(), this.DefaultWriteTaskMetricsEnabled());
            BytesInBatch x$1 = batchSize;
            int x$2 = batchBufferSize;
            BatchGroupingKey x$3 = batchGroupingKey;
            ConsistencyLevel x$4 = consistencyLevel;
            int x$5 = parallelismLevel;
            int x$6 = throughputMiBPS;
            boolean x$7 = metricsEnabled;
            TTLOption x$8 = this.apply$default$7();
            TimestampOption x$9 = this.apply$default$8();
            return new WriteConf(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$7);
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value of spark.cassandra.output.batch.size.rows: ", ". Number or 'auto' expected"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public WriteConf apply(BatchSize batchSize, int batchGroupingBufferSize, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, int parallelismLevel, int throughputMiBPS, TTLOption ttl, TimestampOption timestamp, boolean taskMetricsEnabled) {
        return new WriteConf(batchSize, batchGroupingBufferSize, batchGroupingKey, consistencyLevel, parallelismLevel, throughputMiBPS, ttl, timestamp, taskMetricsEnabled);
    }

    public Option<Tuple9<BatchSize, Object, BatchGroupingKey, ConsistencyLevel, Object, Object, TTLOption, TimestampOption, Object>> unapply(WriteConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.batchSize(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGroupingBufferSize()), (Object)x$0.batchGroupingKey(), (Object)x$0.consistencyLevel(), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelismLevel()), (Object)BoxesRunTime.boxToInteger((int)x$0.throughputMiBPS()), (Object)x$0.ttl(), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.taskMetricsEnabled())));
    }

    public BatchSize $lessinit$greater$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public int $lessinit$greater$default$2() {
        return this.DefaultBatchGroupingBufferSize();
    }

    public BatchGroupingKey $lessinit$greater$default$3() {
        return this.DefaultBatchGroupingKey();
    }

    public ConsistencyLevel $lessinit$greater$default$4() {
        return this.DefaultConsistencyLevel();
    }

    public int $lessinit$greater$default$5() {
        return this.DefaultParallelismLevel();
    }

    public int $lessinit$greater$default$6() {
        return this.DefaultThroughputMiBPS();
    }

    public TTLOption $lessinit$greater$default$7() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public TimestampOption $lessinit$greater$default$8() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean $lessinit$greater$default$9() {
        return this.DefaultWriteTaskMetricsEnabled();
    }

    public BatchSize apply$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public int apply$default$2() {
        return this.DefaultBatchGroupingBufferSize();
    }

    public BatchGroupingKey apply$default$3() {
        return this.DefaultBatchGroupingKey();
    }

    public ConsistencyLevel apply$default$4() {
        return this.DefaultConsistencyLevel();
    }

    public int apply$default$5() {
        return this.DefaultParallelismLevel();
    }

    public int apply$default$6() {
        return this.DefaultThroughputMiBPS();
    }

    public TTLOption apply$default$7() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public TimestampOption apply$default$8() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean apply$default$9() {
        return this.DefaultWriteTaskMetricsEnabled();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private WriteConf$() {
        MODULE$ = this;
        this.WriteBatchSizeInBytesProperty = "spark.cassandra.output.batch.size.bytes";
        this.WriteConsistencyLevelProperty = "spark.cassandra.output.consistency.level";
        this.WriteBatchSizeInRowsProperty = "spark.cassandra.output.batch.size.rows";
        this.WriteBatchBufferSizeProperty = "spark.cassandra.output.batch.grouping.buffer.size";
        this.WriteBatchLevelProperty = "spark.cassandra.output.batch.grouping.key";
        this.WriteParallelismLevelProperty = "spark.cassandra.output.concurrent.writes";
        this.WriteThroughputMiBPS = "spark.cassandra.output.throughput_mb_per_sec";
        this.WriteTaskMetricsProperty = "spark.cassandra.output.metrics";
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.WriteBatchSizeInBytesProperty(), this.WriteConsistencyLevelProperty(), this.WriteBatchSizeInRowsProperty(), this.WriteBatchBufferSizeProperty(), this.WriteBatchLevelProperty(), this.WriteParallelismLevelProperty(), this.WriteThroughputMiBPS(), this.WriteTaskMetricsProperty()}));
        this.DefaultConsistencyLevel = ConsistencyLevel.LOCAL_ONE;
        this.DefaultBatchSizeInBytes = 1024;
        this.DefaultParallelismLevel = 5;
        this.DefaultBatchGroupingBufferSize = 1000;
        this.DefaultBatchGroupingKey = BatchGroupingKey$Partition$.MODULE$;
        this.DefaultThroughputMiBPS = Integer.MAX_VALUE;
        this.DefaultWriteTaskMetricsEnabled = true;
    }
}

