/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteConf$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.DefaultSource$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CassandraSourceRelation$ {
    public static final CassandraSourceRelation$ MODULE$;
    private final String tableSizeInBytesProperty;
    private final Seq<String> Properties;
    private final String defaultClusterName;

    static {
        new CassandraSourceRelation$();
    }

    public String tableSizeInBytesProperty() {
        return this.tableSizeInBytesProperty;
    }

    public Seq<String> Properties() {
        return this.Properties;
    }

    public String defaultClusterName() {
        return this.defaultClusterName;
    }

    public CassandraSourceRelation apply(TableRef tableRef, SQLContext sqlContext, CassandraSourceOptions options, Option<StructType> schema2) {
        Map sqlConf;
        SparkConf sparkConf = sqlContext.sparkContext().getConf();
        SparkConf conf = this.consolidateConfs(sparkConf, (Map<String, String>)(sqlConf = sqlContext.getAllConfs()), tableRef, options.cassandraConfs());
        Option tableSizeInBytesString = conf.getOption(this.tableSizeInBytesProperty());
        None$ tableSizeInBytes = tableSizeInBytesString.nonEmpty() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)tableSizeInBytesString.get())).toLong())) : None$.MODULE$;
        CassandraConnector cassandraConnector = new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
        ReadConf readConf = ReadConf$.MODULE$.fromSparkConf(conf);
        WriteConf writeConf = WriteConf$.MODULE$.fromSparkConf(conf);
        return new CassandraSourceRelation(tableRef, schema2, options.pushdown(), (Option<Object>)tableSizeInBytes, cassandraConnector, readConf, writeConf, sqlContext);
    }

    public CassandraSourceOptions apply$default$3() {
        return new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2());
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> sqlConf, TableRef tableRef, Map<String, String> tableConf) {
        SparkConf conf = sparkConf.clone();
        DefaultSource$.MODULE$.confProperties().foreach((Function1)new Serializable(sqlConf, tableRef, tableConf, conf){
            public static final long serialVersionUID = 0L;
            private final Map sqlConf$1;
            private final TableRef tableRef$1;
            private final Map tableConf$1;
            private final SparkConf conf$1;

            public final Object apply(String prop) {
                String cluster = (String)this.tableRef$1.cluster().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return CassandraSourceRelation$.MODULE$.defaultClusterName();
                    }
                });
                Option clusterLevelValue = this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cluster, prop})));
                Object object = clusterLevelValue.nonEmpty() ? this.conf$1.set(prop, (String)clusterLevelValue.get()) : BoxedUnit.UNIT;
                Option keyspaceLevelValue = this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cluster, this.tableRef$1.keyspace(), prop})));
                Object object2 = keyspaceLevelValue.nonEmpty() ? this.conf$1.set(prop, (String)keyspaceLevelValue.get()) : BoxedUnit.UNIT;
                Option tableLevelValue = this.tableConf$1.get((Object)prop);
                return tableLevelValue.nonEmpty() ? this.conf$1.set(prop, (String)tableLevelValue.get()) : BoxedUnit.UNIT;
            }
            {
                this.sqlConf$1 = sqlConf$1;
                this.tableRef$1 = tableRef$1;
                this.tableConf$1 = tableConf$1;
                this.conf$1 = conf$1;
            }
        });
        return conf;
    }

    private CassandraSourceRelation$() {
        MODULE$ = this;
        this.tableSizeInBytesProperty = "spark.cassandra.table.size.in.bytes";
        this.Properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tableSizeInBytesProperty()}));
        this.defaultClusterName = "default";
    }
}

