/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.partitioner.Murmur3PartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.dht.LongToken;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenRange;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.math.ScalaNumericAnyConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001f\tAS*\u001e:nkJ\u001c\u0004+\u0019:uSRLwN\\3s)>\\WM\u001c*b]\u001e,7\u000b\u001d7jiR,'\u000fV3ti*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\t)A\u0001\b\u0001\u0001;\tQAk\\6f]J\u000bgnZ3\u0011\ty\t#%J\u0007\u0002?)\u0011\u0001EA\u0001\u0004I\"$\u0018B\u0001\u000f !\t\t2%\u0003\u0002%%\t!Aj\u001c8h!\tqb%\u0003\u0002(?\tIAj\u001c8h)>\\WM\u001c\u0005\u0006S\u0001!IAK\u0001\u000eCN\u001cXM\u001d;O_\"{G.Z:\u0015\u0005-r\u0003CA\t-\u0013\ti#C\u0001\u0003V]&$\b\"B\u0018)\u0001\u0004\u0001\u0014a\u0003;pW\u0016t'+\u00198hKN\u00042!M\u001d=\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003qI\tq\u0001]1dW\u0006<W-\u0003\u0002;w\t\u00191+Z9\u000b\u0005a\u0012\u0002CA\u001f\u001c\u001b\u0005\u0001\u0001\"B \u0001\t\u0013\u0001\u0015!E1tg\u0016\u0014HoU5nS2\f'oU5{KR\u00111&\u0011\u0005\u0006_y\u0002\r\u0001\r\u0005\u0006\u0007\u0002!\t\u0001R\u0001\ni\u0016\u001cHo\u00159mSR$\u0012a\u000b\u0015\u0003\u0005\u001a\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u000b),h.\u001b;\u000b\u0003-\u000b1a\u001c:h\u0013\ti\u0005J\u0001\u0003UKN$\b\"B(\u0001\t\u0003!\u0015a\u0003;fgRtun\u00159mSRD#A\u0014$\t\u000bI\u0003A\u0011\u0001#\u0002\u0019Q,7\u000f\u001e.fe>\u0014vn^:)\u0005E3\u0005\"B+\u0001\t\u0003!\u0015A\u0004;fgR<&/\u00199Be>,h\u000e\u001a\u0015\u0003)\u001a\u0003")
public class Murmur3PartitionerTokenRangeSplitterTest {
    private void assertNoHoles(Seq<TokenRange<Object, LongToken>> tokenRanges) {
        tokenRanges.sliding(2).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<TokenRange<Object, LongToken>> check$ifrefutable$1) {
                Seq<TokenRange<Object, LongToken>> seq = check$ifrefutable$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<TokenRange<Object, LongToken>> x$1) {
                Seq<TokenRange<Object, LongToken>> seq = x$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    TokenRange range1 = (TokenRange)((SeqLike)some.get()).apply(0);
                    TokenRange range2 = (TokenRange)((SeqLike)some.get()).apply(1);
                    Assert.assertEquals((Object)range1.end(), (Object)range2.start());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(seq);
            }
        });
    }

    private void assertSimilarSize(Seq<TokenRange<Object, LongToken>> tokenRanges) {
        Vector sizes = ((TraversableOnce)tokenRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(TokenRange<Object, LongToken> r) {
                return TokenFactory.Murmur3TokenFactory$.MODULE$.distance((LongToken)r.start(), (LongToken)r.end());
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector();
        double maxSize = ((ScalaNumericAnyConversions)sizes.max((Ordering)Ordering.BigInt$.MODULE$)).toDouble();
        double minSize = ((ScalaNumericAnyConversions)sizes.min((Ordering)Ordering.BigInt$.MODULE$)).toDouble();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxSize / minSize = ", " > 1.01"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(maxSize / minSize))})), (maxSize / minSize <= 1.01 ? 1 : 0) != 0);
    }

    @Test
    public void testSplit() {
        InetAddress node = InetAddress.getLocalHost();
        int dataSize = 1000;
        Murmur3PartitionerTokenRangeSplitter splitter = new Murmur3PartitionerTokenRangeSplitter((long)dataSize);
        TokenRange range = new TokenRange((Token)new LongToken(0L), (Token)new LongToken(0L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{node})), (long)dataSize);
        Seq out = splitter.split(range, 100L);
        Assert.assertEquals((long)10L, (long)out.size());
        Assert.assertEquals((long)0L, (long)((LongToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((long)0L, (long)((LongToken)((TokenRange)out.last()).end()).value());
        Assert.assertTrue((boolean)out.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TokenRange<Object, LongToken> s) {
                return ((LongToken)s.end()).value() != ((LongToken)s.start()).value();
            }
        }));
        Assert.assertTrue((boolean)out.forall((Function1)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final InetAddress node$1;

            public final boolean apply(TokenRange<Object, LongToken> x$2) {
                Set set = x$2.replicas();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node$1}));
                return !(set != null ? !set.equals(genTraversable) : genTraversable != null);
            }
            {
                this.node$1 = node$1;
            }
        }));
        this.assertNoHoles((Seq<TokenRange<Object, LongToken>>)out);
        this.assertSimilarSize((Seq<TokenRange<Object, LongToken>>)out);
    }

    @Test
    public void testNoSplit() {
        Murmur3PartitionerTokenRangeSplitter splitter = new Murmur3PartitionerTokenRangeSplitter(1000L);
        TokenRange range = new TokenRange((Token)new LongToken(0L), (Token)new LongToken(100L), Predef$.MODULE$.Set().empty(), 0L);
        Seq out = splitter.split(range, 500L);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertEquals((long)0L, (long)((LongToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((long)100L, (long)((LongToken)((TokenRange)out.last()).end()).value());
    }

    @Test
    public void testZeroRows() {
        int dataSize = 0;
        Murmur3PartitionerTokenRangeSplitter splitter = new Murmur3PartitionerTokenRangeSplitter((long)dataSize);
        TokenRange range = new TokenRange((Token)new LongToken(0L), (Token)new LongToken(100L), Predef$.MODULE$.Set().empty(), (long)dataSize);
        Seq out = splitter.split(range, 500L);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertEquals((long)0L, (long)((LongToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((long)100L, (long)((LongToken)((TokenRange)out.last()).end()).value());
    }

    @Test
    public void testWrapAround() {
        int dataSize = 2000;
        Murmur3PartitionerTokenRangeSplitter splitter = new Murmur3PartitionerTokenRangeSplitter((long)dataSize);
        long start = TokenFactory.Murmur3TokenFactory$.MODULE$.maxToken().value() - 0x3FFFFFFFFFFFFFFFL;
        long end = TokenFactory.Murmur3TokenFactory$.MODULE$.minToken().value() + 0x3FFFFFFFFFFFFFFFL;
        TokenRange range = new TokenRange((Token)new LongToken(start), (Token)new LongToken(end), Predef$.MODULE$.Set().empty(), (long)(dataSize / 2));
        Seq splits = splitter.split(range, 100L);
        Assert.assertEquals((long)10L, (long)splits.size());
        Assert.assertEquals((long)start, (long)((LongToken)((TokenRange)splits.head()).start()).value());
        Assert.assertEquals((long)end, (long)((LongToken)((TokenRange)splits.last()).end()).value());
        this.assertNoHoles((Seq<TokenRange<Object, LongToken>>)splits);
        this.assertSimilarSize((Seq<TokenRange<Object, LongToken>>)splits);
    }
}

